/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.autowhitelistremove.hyperlib.releases.hangar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lol.hyper.autowhitelistremove.hyperlib.HyperLib;
import lol.hyper.autowhitelistremove.hyperlib.releases.hangar.HangarDownload;
import lol.hyper.autowhitelistremove.hyperlib.releases.hangar.HangarRelease;
import lol.hyper.autowhitelistremove.hyperlib.utils.JSONUtils;
import lol.hyper.toolstats.shaded.json.JSONArray;
import lol.hyper.toolstats.shaded.json.JSONObject;
import org.jetbrains.annotations.Nullable;

public class HangarPlugin {
    private final String projectID;
    private final String loader;
    private String author;
    private String latest;
    private final List<HangarRelease> releases = new ArrayList<HangarRelease>();

    public HangarPlugin(String projectID, String loader) {
        this.projectID = projectID;
        this.loader = loader;
    }

    public void get() {
        String projectUrl = "https://hangar.papermc.io/api/v1/projects/" + this.projectID;
        JSONObject projectFetch = JSONUtils.requestJSONObject(projectUrl);
        if (projectFetch == null) {
            HyperLib.getPluginLogger().error("Unable to fetch plugin information from {}", (Object)projectUrl);
            return;
        }
        JSONObject namespace = projectFetch.getJSONObject("namespace");
        this.author = namespace.getString("owner");
        String versionsUrl = "https://hangar.papermc.io/api/v1/projects/" + this.projectID + "/versions";
        JSONObject versionsFetch = JSONUtils.requestJSONObject(versionsUrl);
        if (versionsFetch == null) {
            HyperLib.getPluginLogger().error("Unable to fetch plugin information from {}", (Object)versionsUrl);
            return;
        }
        JSONArray result = versionsFetch.getJSONArray("result");
        for (int i = 0; i < result.length(); ++i) {
            JSONObject releaseData = result.getJSONObject(i);
            String version = releaseData.getString("name");
            HangarRelease release = new HangarRelease(version, this.loader);
            release.setReleaseDate(releaseData.getString("createdAt"));
            release.setAuthor(releaseData.getString("author"));
            release.setVersionPage(this.getProjectPage() + "/versions/" + version);
            JSONObject platformDependencies = releaseData.getJSONObject("platformDependencies");
            if (!platformDependencies.has(this.loader.toUpperCase(Locale.ROOT))) continue;
            JSONArray platformVersions = platformDependencies.getJSONArray(this.loader.toUpperCase(Locale.ROOT));
            for (int j = 0; j < platformVersions.length(); ++j) {
                release.addSupportedVersion(platformVersions.getString(j));
            }
            HangarDownload hangarDownload = new HangarDownload(release.getVersion());
            JSONObject downloads = releaseData.getJSONObject("downloads");
            JSONObject loaderDownloads = downloads.getJSONObject(this.loader.toUpperCase(Locale.ROOT));
            String downloadUrl = loaderDownloads.optString("downloadUrl");
            String externalUrl = loaderDownloads.optString("externalUrl");
            if (!downloadUrl.isEmpty()) {
                hangarDownload.setDownloadUrl(downloadUrl);
                JSONObject fileInfo = loaderDownloads.getJSONObject("fileInfo");
                hangarDownload.setFileName(fileInfo.getString("name"));
                hangarDownload.setSha256Hash(fileInfo.getString("sha256Hash"));
            } else if (!externalUrl.isEmpty()) {
                hangarDownload.setDownloadUrl(externalUrl);
                hangarDownload.setFileName(null);
                hangarDownload.setSha256Hash(null);
            } else {
                hangarDownload.setDownloadUrl(null);
            }
            release.addDownload(hangarDownload);
            this.releases.add(release);
            if (i != 0) continue;
            this.latest = version;
        }
    }

    public List<HangarRelease> getReleases() {
        return this.releases;
    }

    @Nullable
    public HangarRelease getReleaseByVersion(String version) {
        return this.releases.stream().filter(release -> release.getVersion().equalsIgnoreCase(version)).findFirst().orElse(null);
    }

    @Nullable
    public HangarRelease getLatestRelease() {
        return this.releases.stream().filter(release -> release.getVersion().equalsIgnoreCase(this.latest)).findFirst().get();
    }

    public int buildsVersionsBehind(HangarRelease release) {
        return this.releases.indexOf(release);
    }

    public String getProjectPage() {
        return "https://hangar.papermc.io/" + this.author + "/" + this.projectID;
    }
}

