/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.autowhitelistremove.hyperlib.releases.modrinth;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lol.hyper.autowhitelistremove.hyperlib.releases.modrinth.ModrinthDownload;

public class ModrinthRelease {
    private final ArrayList<String> supportedVersions = new ArrayList();
    private final ArrayList<String> supportedLoaders = new ArrayList();
    private final String version;
    private Date releaseDate;
    private String releaseType;
    private String versionPage;
    private final List<ModrinthDownload> downloads = new ArrayList<ModrinthDownload>();

    public ModrinthRelease(String version) {
        this.version = version;
    }

    public void addSupportedVersion(String version) {
        this.supportedVersions.add(version);
    }

    public List<String> getSupportedVersions() {
        return this.supportedVersions;
    }

    public List<String> getSupportedLoaders() {
        return this.supportedLoaders;
    }

    public void addSupportedLoader(String loader) {
        this.supportedLoaders.add(loader);
    }

    public String getVersion() {
        return this.version;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(releaseDate, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.releaseDate = Date.from(offsetDateTime.toInstant());
    }

    public String getReleaseType() {
        return this.releaseType;
    }

    public void setReleaseType(String releaseType) {
        this.releaseType = releaseType;
    }

    public List<ModrinthDownload> getDownloads() {
        return this.downloads;
    }

    public void addDownload(ModrinthDownload download) {
        this.downloads.add(download);
    }

    public void setVersionPage(String versionPage) {
        this.versionPage = versionPage;
    }

    public String getVersionPage() {
        return this.versionPage;
    }

    public String toString() {
        return this.version;
    }
}

