/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.autowhitelistremove.tools;

import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lol.hyper.autowhitelistremove.AutoWhitelistRemove;
import lol.hyper.autowhitelistremove.hyperlib.utils.FileUtils;
import lol.hyper.autowhitelistremove.json.JSONArray;
import lol.hyper.autowhitelistremove.json.JSONObject;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WhitelistCheck {
    final Pattern pattern = Pattern.compile("\\d+([wdm])", 2);
    private final AutoWhitelistRemove autoWhitelistRemove;

    public WhitelistCheck(AutoWhitelistRemove autoWhitelistRemove) {
        this.autoWhitelistRemove = autoWhitelistRemove;
    }

    public boolean verifyTimeDuration(String timeInConfig) {
        Matcher matcher = this.pattern.matcher(timeInConfig);
        return matcher.matches();
    }

    public Set<String> checkWhitelist(boolean actuallyRemove) {
        HashSet<String> inactivePlayersName = new HashSet<String>();
        HashSet<OfflinePlayer> inactivePlayers = new HashSet<OfflinePlayer>();
        String inactivePeriod = this.autoWhitelistRemove.config.getString("inactive-period");
        if (inactivePeriod == null) {
            this.autoWhitelistRemove.logger.warn("inactive-period is NOT SET!");
            return Collections.emptySet();
        }
        this.autoWhitelistRemove.logger.info("Checking for inactive players...");
        this.autoWhitelistRemove.logger.info("Current duration is set to {}", (Object)inactivePeriod);
        int inactivePlayersCounter = 0;
        for (OfflinePlayer offlinePlayer : Bukkit.getWhitelistedPlayers()) {
            UUID uuid = offlinePlayer.getUniqueId();
            String playerUsername = offlinePlayer.getName();
            if (!offlinePlayer.hasPlayedBefore() || offlinePlayer.getLastLogin() == 0L) {
                offlinePlayer.setWhitelisted(false);
                this.autoWhitelistRemove.logger.info("Skipping player {} since they have not played yet.", (Object)playerUsername);
                continue;
            }
            if (this.autoWhitelistRemove.config.getStringList("ignored-players").contains(uuid.toString())) {
                this.autoWhitelistRemove.logger.info("Skipping player {} because their UUID is on the ignored list.", (Object)playerUsername);
                continue;
            }
            if (this.autoWhitelistRemove.config.getStringList("ignored-players").contains(playerUsername)) {
                this.autoWhitelistRemove.logger.info("Skipping player {} because their name is on the ignored list.", (Object)playerUsername);
                continue;
            }
            boolean inactive = this.isPlayerInactive(offlinePlayer, inactivePeriod);
            if (!inactive) continue;
            ++inactivePlayersCounter;
            inactivePlayersName.add(offlinePlayer.getName());
            inactivePlayers.add(offlinePlayer);
        }
        if (inactivePlayersCounter > 0) {
            if (actuallyRemove) {
                this.autoWhitelistRemove.logger.info("{} players are going to be removed: {}", (Object)inactivePlayersCounter, inactivePlayersName);
                this.removePlayers(inactivePlayers);
            } else {
                this.autoWhitelistRemove.logger.info("{} players can be removed: {}", (Object)inactivePlayersCounter, inactivePlayersName);
            }
        } else {
            this.autoWhitelistRemove.logger.info("No inactive players found.");
        }
        return inactivePlayersName;
    }

    private void removePlayers(Set<OfflinePlayer> playersToRemove) {
        List commands = this.autoWhitelistRemove.config.getStringList("extra-commands");
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.autoWhitelistRemove, t -> {
            for (OfflinePlayer offlinePlayer : playersToRemove) {
                if (!commands.isEmpty()) {
                    for (String command : commands) {
                        String finalCommand = this.getCommand(offlinePlayer, command);
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
                    }
                }
                offlinePlayer.setWhitelisted(false);
            }
        });
        if (this.autoWhitelistRemove.config.getBoolean("save-whitelist-removals")) {
            this.exportPlayers(playersToRemove);
        }
    }

    @NotNull
    private String getCommand(OfflinePlayer offlinePlayer, String command) {
        String finalCommand = command;
        if (command.contains("%player%")) {
            String playerName = offlinePlayer.getName() != null ? offlinePlayer.getName() : "UnknownPlayer";
            finalCommand = command.replace("%player%", playerName);
        }
        if (command.contains("%uuid%")) {
            finalCommand = command.replace("%uuid%", offlinePlayer.getUniqueId().toString());
        }
        return finalCommand;
    }

    public long getWeeksBetween(Date d1, Date d2) {
        return ChronoUnit.WEEKS.between(d1.toInstant().atZone(ZoneId.systemDefault()), d2.toInstant().atZone(ZoneId.systemDefault()));
    }

    public long getDaysBetween(Date d1, Date d2) {
        return ChronoUnit.DAYS.between(d1.toInstant().atZone(ZoneId.systemDefault()), d2.toInstant().atZone(ZoneId.systemDefault()));
    }

    public long getMonthsBetween(Date d1, Date d2) {
        return ChronoUnit.MONTHS.between(d1.toInstant().atZone(ZoneId.systemDefault()), d2.toInstant().atZone(ZoneId.systemDefault()));
    }

    private boolean isPlayerInactive(OfflinePlayer playerToCheck, String inactivePeriod) {
        String playerUsername = playerToCheck.getName();
        String timeType = inactivePeriod.substring(inactivePeriod.length() - 1);
        Date lastPlayed = new Date(playerToCheck.getLastLogin());
        int duration = Integer.parseInt(inactivePeriod.substring(0, inactivePeriod.length() - 1));
        switch (timeType) {
            case "w": {
                long weeksBetween = this.getWeeksBetween(lastPlayed, new Date());
                if (weeksBetween < (long)duration) break;
                this.autoWhitelistRemove.logger.info("{} can be removed! They haven't played in over {} weeks! Last online: {} weeks ago.", new Object[]{playerUsername, duration, weeksBetween});
                return true;
            }
            case "d": {
                long daysBetween = this.getDaysBetween(lastPlayed, new Date());
                if (daysBetween < (long)duration) break;
                this.autoWhitelistRemove.logger.info("{} can be removed! They haven't played in over {} days! Last online: {} days ago.", new Object[]{playerUsername, duration, daysBetween});
                return true;
            }
            case "m": {
                long monthsBetween = this.getMonthsBetween(lastPlayed, new Date());
                if (monthsBetween < (long)duration) break;
                this.autoWhitelistRemove.logger.info("{} can be removed! They haven't played in over {} months! Last online: {} months ago.", new Object[]{playerUsername, duration, monthsBetween});
                return true;
            }
            default: {
                this.autoWhitelistRemove.logger.warn("Invalid time duration {}! Please check your config!", (Object)timeType);
            }
        }
        return false;
    }

    private void exportPlayers(Set<OfflinePlayer> players) {
        String arrayRaw = this.autoWhitelistRemove.removalsFile.exists() ? FileUtils.readFile(this.autoWhitelistRemove.removalsFile) : "[]";
        JSONArray array = new JSONArray(arrayRaw);
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String strDate = dateFormat.format(date);
        for (OfflinePlayer player : players) {
            JSONObject object = new JSONObject();
            object.put("name", player.getName());
            object.put("uuid", player.getUniqueId());
            object.put("date", strDate);
            array.put(object);
        }
        FileUtils.writeFile(array.toString(4), this.autoWhitelistRemove.removalsFile);
    }
}

