/*
 * Decompiled with CFR 0.152.
 */
package locationalArmorAddon.math;

import locationalArmorAddon.config.Config;
import locationalArmorAddon.util.PlayerUtils;
import org.bukkit.Keyed;
import org.bukkit.damage.DamageType;
import org.bukkit.tag.DamageTypeTags;

public class DamageCalculator {
    public static double getArmorDamageReductionRatio(double originalDamage, DamageType damageType, PlayerUtils.ArmorStats stats, int breachLevel) {
        if (DamageTypeTags.BYPASSES_ARMOR.isTagged((Keyed)damageType)) {
            return 0.0;
        }
        double cappedArmorPoints = Math.min(30.0, stats.armorPoints());
        double cappedArmorToughness = Math.min(20.0, stats.armorToughness());
        double damageFactor = 4.0 * originalDamage / (cappedArmorToughness + 8.0);
        double effectiveReduction = Math.max(cappedArmorPoints / 5.0, cappedArmorPoints - damageFactor);
        double cappedReductionRatio = Math.min(20.0, effectiveReduction) / 25.0;
        return Math.max(0.0, cappedReductionRatio - (double)breachLevel * 0.15);
    }

    public static double applyArmorDamageReduction(double originalDamage, DamageType damageType, PlayerUtils.ArmorStats stats, int breachLevel) {
        if (DamageTypeTags.BYPASSES_ARMOR.isTagged((Keyed)damageType)) {
            return originalDamage;
        }
        double finalReductionRatio = DamageCalculator.getArmorDamageReductionRatio(originalDamage, damageType, stats, breachLevel);
        return originalDamage * (1.0 - finalReductionRatio);
    }

    public static double reverseArmorDamageReduction(double reducedDamage, DamageType damageType, PlayerUtils.ArmorStats stats, int breachLevel) {
        double low = reducedDamage;
        double high = reducedDamage * 5.0;
        while (high - low > Config.binary_search_precision) {
            double mid = (low + high) / 2.0;
            double computed = DamageCalculator.applyArmorDamageReduction(mid, damageType, stats, breachLevel);
            if (computed > reducedDamage) {
                high = mid;
                continue;
            }
            low = mid;
        }
        double result = (double)Math.round((low + high) / 2.0 * 100.0) / 100.0;
        return result;
    }

    public static double getEnchantmentDamageReductionRatio(DamageType damageType, EnchantmentLevels enchantmentLevels) {
        double totalReduction = 0.0;
        if (!DamageCalculator.isExemptFromProtection(damageType)) {
            totalReduction += (double)enchantmentLevels.protection * 0.04;
        }
        if (DamageTypeTags.IS_EXPLOSION.isTagged((Keyed)damageType)) {
            totalReduction += (double)enchantmentLevels.blastProtection * 0.08;
        }
        if (DamageTypeTags.IS_FIRE.isTagged((Keyed)damageType)) {
            totalReduction += (double)enchantmentLevels.fireProtection * 0.08;
        }
        if (DamageTypeTags.IS_PROJECTILE.isTagged((Keyed)damageType)) {
            totalReduction += (double)enchantmentLevels.projectileProtection * 0.08;
        }
        if (DamageTypeTags.IS_FALL.isTagged((Keyed)damageType)) {
            totalReduction += (double)enchantmentLevels.featherFalling * 0.12;
        }
        totalReduction = Math.min(totalReduction, 0.8);
        return totalReduction;
    }

    public static double applyEnchantmentDamageReduction(double originalDamage, DamageType damageType, EnchantmentLevels enchantmentLevels) {
        if (DamageTypeTags.BYPASSES_ENCHANTMENTS.isTagged((Keyed)damageType)) {
            return originalDamage;
        }
        double reductionRatio = DamageCalculator.getEnchantmentDamageReductionRatio(damageType, enchantmentLevels);
        return originalDamage * (1.0 - reductionRatio);
    }

    public static double reverseEnchantmentDamageReduction(double reducedDamage, DamageType damageType, EnchantmentLevels enchantmentLevels) {
        if (DamageTypeTags.BYPASSES_ENCHANTMENTS.isTagged((Keyed)damageType)) {
            return reducedDamage;
        }
        double reductionRatio = DamageCalculator.getEnchantmentDamageReductionRatio(damageType, enchantmentLevels);
        return reducedDamage / (1.0 - reductionRatio);
    }

    public static boolean isExemptFromProtection(DamageType damageType) {
        return damageType == DamageType.STARVE || damageType == DamageType.SONIC_BOOM || damageType == DamageType.OUT_OF_WORLD || damageType == DamageType.GENERIC_KILL;
    }

    public static double getEffectDamageReductionRatio(DamageType damageType, int resistanceLevel) {
        if (DamageTypeTags.BYPASSES_EFFECTS.isTagged((Keyed)damageType)) {
            return 0.0;
        }
        double totalReduction = 0.0;
        if (!DamageTypeTags.BYPASSES_RESISTANCE.isTagged((Keyed)damageType)) {
            totalReduction += (double)resistanceLevel * 0.2;
        }
        return totalReduction;
    }

    public static double applyEffectDamageReduction(double originalDamage, DamageType damageType, int resistanceLevel) {
        if (DamageTypeTags.BYPASSES_EFFECTS.isTagged((Keyed)damageType)) {
            return originalDamage;
        }
        double reductionRatio = DamageCalculator.getEffectDamageReductionRatio(damageType, resistanceLevel);
        return originalDamage * (1.0 - reductionRatio);
    }

    public static double reverseEffectDamageReduction(double originalDamage, DamageType damageType, int resistanceLevel) {
        if (DamageTypeTags.BYPASSES_EFFECTS.isTagged((Keyed)damageType)) {
            return originalDamage;
        }
        double reductionRatio = DamageCalculator.getEffectDamageReductionRatio(damageType, resistanceLevel);
        return originalDamage / (1.0 - reductionRatio);
    }

    public record EnchantmentLevels(int protection, int blastProtection, int fireProtection, int projectileProtection, int featherFalling) {
    }
}

