/*
 * Decompiled with CFR 0.152.
 */
package locationalArmorAddon.core;

import bodyhealth.core.BodyPart;
import locationalArmorAddon.Main;
import locationalArmorAddon.math.DamageCalculator;
import locationalArmorAddon.util.PlayerUtils;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Player;

public class BodyPartDamage {
    public DamageType DAMAGE_TYPE;
    public double BASE_DAMAGE;
    public double PRE_EFFECT_DAMAGE;
    public double PRE_ENCHANTMENT_DAMAGE;
    public double PRE_ARMOR_DAMAGE;
    public double EFFECT_DAMAGE_ABSORPTION;
    public double LOCAL_ENCHANTMENT_ABSORPTION;
    public double TOTAL_ENCHANTMENT_ABSORPTION;
    public double LOCAL_ARMOR_ABSORPTION;
    public double TOTAL_ARMOR_ABSORPTION;
    public double EFFECT_DAMAGE_REDUCTION_RATIO;
    public double LOCAL_ENCHANTMENT_REDUCTION_RATIO;
    public double TOTAL_ENCHANTMENT_REDUCTION_RATIO;
    public double LOCAL_ARMOR_REDUCTION_RATIO;
    public double TOTAL_ARMOR_REDUCTION_RATIO;

    public BodyPartDamage(double baseDamage, DamageType damageType, Player player, BodyPart bodyPart, int breachLevel) {
        Main.debug().logDev("");
        Main.debug().logDev(player.getName() + "'s " + bodyPart.name() + " received " + baseDamage + " damage (type " + damageType.getKey().getKey().toUpperCase() + ") with breach level " + breachLevel);
        int resistanceLevel = PlayerUtils.getResistanceLevel(player);
        Main.debug().logDev("Resistance effect level: " + resistanceLevel);
        DamageCalculator.EnchantmentLevels totalEnchantmentLevels = PlayerUtils.getTotalEnchantmentLevels(player);
        DamageCalculator.EnchantmentLevels localEnchantmentLevels = PlayerUtils.getLocalEnchantmentLevels(player, bodyPart);
        PlayerUtils.ArmorStats totalArmorStats = PlayerUtils.getTotalArmorStats(player);
        PlayerUtils.ArmorStats localArmorStats = PlayerUtils.getLocalArmorStats(player, bodyPart);
        Main.debug().logDev("Total Armor Points: " + totalArmorStats.armorPoints());
        Main.debug().logDev("Total Armor Toughness: " + totalArmorStats.armorToughness());
        Main.debug().logDev("Local Armor Points: " + localArmorStats.armorPoints());
        Main.debug().logDev("Local Armor Toughness: " + localArmorStats.armorToughness());
        this.DAMAGE_TYPE = damageType;
        this.BASE_DAMAGE = baseDamage;
        this.PRE_EFFECT_DAMAGE = DamageCalculator.reverseEffectDamageReduction(this.BASE_DAMAGE, this.DAMAGE_TYPE, resistanceLevel);
        this.EFFECT_DAMAGE_ABSORPTION = this.PRE_EFFECT_DAMAGE - this.BASE_DAMAGE;
        this.EFFECT_DAMAGE_REDUCTION_RATIO = DamageCalculator.getEffectDamageReductionRatio(this.DAMAGE_TYPE, resistanceLevel);
        this.PRE_ENCHANTMENT_DAMAGE = DamageCalculator.reverseEnchantmentDamageReduction(this.PRE_EFFECT_DAMAGE, this.DAMAGE_TYPE, totalEnchantmentLevels);
        this.TOTAL_ENCHANTMENT_ABSORPTION = this.PRE_ENCHANTMENT_DAMAGE - this.PRE_EFFECT_DAMAGE;
        this.TOTAL_ENCHANTMENT_REDUCTION_RATIO = DamageCalculator.getEnchantmentDamageReductionRatio(this.DAMAGE_TYPE, totalEnchantmentLevels);
        this.LOCAL_ENCHANTMENT_REDUCTION_RATIO = DamageCalculator.getEnchantmentDamageReductionRatio(this.DAMAGE_TYPE, localEnchantmentLevels);
        this.LOCAL_ENCHANTMENT_ABSORPTION = this.PRE_ENCHANTMENT_DAMAGE - DamageCalculator.applyEnchantmentDamageReduction(this.PRE_ENCHANTMENT_DAMAGE, this.DAMAGE_TYPE, localEnchantmentLevels);
        this.PRE_ARMOR_DAMAGE = DamageCalculator.reverseArmorDamageReduction(this.PRE_ENCHANTMENT_DAMAGE, this.DAMAGE_TYPE, totalArmorStats, breachLevel);
        this.TOTAL_ARMOR_ABSORPTION = this.PRE_ARMOR_DAMAGE - this.PRE_ENCHANTMENT_DAMAGE;
        this.TOTAL_ARMOR_REDUCTION_RATIO = DamageCalculator.getArmorDamageReductionRatio(this.PRE_ARMOR_DAMAGE, this.DAMAGE_TYPE, totalArmorStats, breachLevel);
        this.LOCAL_ARMOR_REDUCTION_RATIO = DamageCalculator.getArmorDamageReductionRatio(this.PRE_ARMOR_DAMAGE, this.DAMAGE_TYPE, localArmorStats, breachLevel);
        this.LOCAL_ARMOR_ABSORPTION = this.PRE_ARMOR_DAMAGE - DamageCalculator.applyArmorDamageReduction(this.PRE_ARMOR_DAMAGE, this.DAMAGE_TYPE, localArmorStats, breachLevel);
        Main.debug().logDev("");
        Main.debug().logDev("BASE_DAMAGE: " + this.BASE_DAMAGE);
        Main.debug().logDev("PRE_EFFECT_DAMAGE: " + this.PRE_EFFECT_DAMAGE);
        Main.debug().logDev("EFFECT_DAMAGE_ABSORPTION: " + this.EFFECT_DAMAGE_ABSORPTION);
        Main.debug().logDev("EFFECT_DAMAGE_REDUCTION_RATIO: " + this.EFFECT_DAMAGE_REDUCTION_RATIO);
        Main.debug().logDev("PRE_ENCHANTMENT_DAMAGE: " + this.PRE_ENCHANTMENT_DAMAGE);
        Main.debug().logDev("TOTAL_ENCHANTMENT_ABSORPTION: " + this.TOTAL_ENCHANTMENT_ABSORPTION);
        Main.debug().logDev("TOTAL_ENCHANTMENT_REDUCTION_RATIO: " + this.TOTAL_ENCHANTMENT_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ENCHANTMENT_REDUCTION_RATIO: " + this.LOCAL_ENCHANTMENT_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ENCHANTMENT_ABSORPTION: " + this.LOCAL_ENCHANTMENT_ABSORPTION);
        Main.debug().logDev("PRE_ARMOR_DAMAGE: " + this.PRE_ARMOR_DAMAGE);
        Main.debug().logDev("TOTAL_ARMOR_ABSORPTION: " + this.TOTAL_ARMOR_ABSORPTION);
        Main.debug().logDev("TOTAL_ARMOR_REDUCTION_RATIO: " + this.TOTAL_ARMOR_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ARMOR_REDUCTION_RATIO: " + this.LOCAL_ARMOR_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ARMOR_ABSORPTION: " + this.LOCAL_ARMOR_ABSORPTION);
        Main.debug().logDev("");
    }
}

