/*
 * Decompiled with CFR 0.152.
 */
package locationalArmorAddon.util;

import bodyhealth.core.BodyPart;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import locationalArmorAddon.Main;
import locationalArmorAddon.config.Config;
import locationalArmorAddon.math.DamageCalculator;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerUtils {
    public static int getResistanceLevel(Player player) {
        PotionEffect effect = player.getPotionEffect(PotionEffectType.RESISTANCE);
        if (effect == null) {
            return 0;
        }
        return effect.getAmplifier() + 1;
    }

    public static DamageCalculator.EnchantmentLevels getTotalEnchantmentLevels(Player player) {
        int protection = 0;
        int blastProtection = 0;
        int fireProtection = 0;
        int projectileProtection = 0;
        int featherFalling = 0;
        for (ItemStack armorPiece : player.getInventory().getArmorContents()) {
            if (armorPiece == null || armorPiece.getType().isAir()) continue;
            Map enchantments = armorPiece.getEnchantments();
            protection += enchantments.getOrDefault(Enchantment.PROTECTION, 0).intValue();
            blastProtection += enchantments.getOrDefault(Enchantment.BLAST_PROTECTION, 0).intValue();
            fireProtection += enchantments.getOrDefault(Enchantment.FIRE_PROTECTION, 0).intValue();
            projectileProtection += enchantments.getOrDefault(Enchantment.PROJECTILE_PROTECTION, 0).intValue();
            featherFalling += enchantments.getOrDefault(Enchantment.FEATHER_FALLING, 0).intValue();
        }
        Main.debug().logDev("Total Protection: " + protection);
        Main.debug().logDev("Total BlastProtection: " + blastProtection);
        Main.debug().logDev("Total FireProtection: " + fireProtection);
        Main.debug().logDev("Total ProjectileProtection: " + projectileProtection);
        Main.debug().logDev("Total FeatherFalling: " + featherFalling);
        return new DamageCalculator.EnchantmentLevels(protection, blastProtection, fireProtection, projectileProtection, featherFalling);
    }

    public static DamageCalculator.EnchantmentLevels getLocalEnchantmentLevels(Player player, BodyPart bodyPart) {
        EquipmentSlot localArmorPiece;
        switch (bodyPart) {
            default: {
                throw new MatchException(null, null);
            }
            case HEAD: {
                EquipmentSlot equipmentSlot = EquipmentSlot.HEAD;
                break;
            }
            case BODY: {
                EquipmentSlot equipmentSlot = EquipmentSlot.CHEST;
                break;
            }
            case ARM_LEFT: 
            case ARM_RIGHT: {
                EquipmentSlot equipmentSlot;
                if (Config.chestplate_protects_hands) {
                    equipmentSlot = EquipmentSlot.CHEST;
                    break;
                }
                equipmentSlot = null;
                break;
            }
            case LEG_LEFT: 
            case LEG_RIGHT: {
                EquipmentSlot equipmentSlot = EquipmentSlot.LEGS;
                break;
            }
            case FOOT_LEFT: 
            case FOOT_RIGHT: {
                EquipmentSlot equipmentSlot = localArmorPiece = EquipmentSlot.FEET;
            }
        }
        if (localArmorPiece == null) {
            return new DamageCalculator.EnchantmentLevels(0, 0, 0, 0, 0);
        }
        ItemStack armorPiece = player.getInventory().getItem(localArmorPiece);
        if (armorPiece == null || armorPiece.getType().isAir()) {
            return new DamageCalculator.EnchantmentLevels(0, 0, 0, 0, 0);
        }
        Map enchantments = armorPiece.getEnchantments();
        Main.debug().logDev("Local Protection: " + String.valueOf(enchantments.getOrDefault(Enchantment.PROTECTION, 0)));
        Main.debug().logDev("Local BlastProtection: " + String.valueOf(enchantments.getOrDefault(Enchantment.BLAST_PROTECTION, 0)));
        Main.debug().logDev("Local FireProtection: " + String.valueOf(enchantments.getOrDefault(Enchantment.FIRE_PROTECTION, 0)));
        Main.debug().logDev("Local ProjectileProtection: " + String.valueOf(enchantments.getOrDefault(Enchantment.PROJECTILE_PROTECTION, 0)));
        Main.debug().logDev("Local FeatherFalling: " + String.valueOf(enchantments.getOrDefault(Enchantment.FEATHER_FALLING, 0)));
        return new DamageCalculator.EnchantmentLevels(enchantments.getOrDefault(Enchantment.PROTECTION, 0), enchantments.getOrDefault(Enchantment.BLAST_PROTECTION, 0), enchantments.getOrDefault(Enchantment.FIRE_PROTECTION, 0), enchantments.getOrDefault(Enchantment.PROJECTILE_PROTECTION, 0), enchantments.getOrDefault(Enchantment.FEATHER_FALLING, 0));
    }

    public static ArmorStats getTotalArmorStats(Player player) {
        AttributeInstance armorAttribute = player.getAttribute(Attribute.ARMOR);
        AttributeInstance toughnessAttribute = player.getAttribute(Attribute.ARMOR_TOUGHNESS);
        double armor = armorAttribute != null ? armorAttribute.getValue() : 0.0;
        double toughness = toughnessAttribute != null ? toughnessAttribute.getValue() : 0.0;
        return new ArmorStats(armor, toughness);
    }

    public static ArmorStats getLocalArmorStats(Player player, BodyPart bodyPart) {
        EquipmentSlot slot;
        switch (bodyPart) {
            default: {
                throw new MatchException(null, null);
            }
            case HEAD: {
                EquipmentSlot equipmentSlot = EquipmentSlot.HEAD;
                break;
            }
            case BODY: {
                EquipmentSlot equipmentSlot = EquipmentSlot.CHEST;
                break;
            }
            case ARM_LEFT: 
            case ARM_RIGHT: {
                EquipmentSlot equipmentSlot;
                if (Config.chestplate_protects_hands) {
                    equipmentSlot = EquipmentSlot.CHEST;
                    break;
                }
                equipmentSlot = null;
                break;
            }
            case LEG_LEFT: 
            case LEG_RIGHT: {
                EquipmentSlot equipmentSlot = EquipmentSlot.LEGS;
                break;
            }
            case FOOT_LEFT: 
            case FOOT_RIGHT: {
                EquipmentSlot equipmentSlot = slot = EquipmentSlot.FEET;
            }
        }
        if (slot == null) {
            return new ArmorStats(0.0, 0.0);
        }
        ItemStack item = player.getInventory().getItem(slot);
        if (item == null || item.getType().isAir()) {
            return new ArmorStats(0.0, 0.0);
        }
        String key = switch (slot) {
            case EquipmentSlot.HEAD -> "helmet";
            case EquipmentSlot.CHEST -> "chestplate";
            case EquipmentSlot.LEGS -> "leggings";
            case EquipmentSlot.FEET -> "boots";
            default -> "";
        };
        List<AttributeModifier> baseArmorPointModifiers = Objects.requireNonNull(player.getAttribute(Attribute.ARMOR)).getModifiers().stream().filter(mod -> mod.getKey().getKey().equalsIgnoreCase("armor." + key)).toList();
        List<AttributeModifier> baseArmorToughnessModifiers = Objects.requireNonNull(player.getAttribute(Attribute.ARMOR_TOUGHNESS)).getModifiers().stream().filter(mod -> mod.getKey().getKey().equalsIgnoreCase("armor." + key)).toList();
        double baseArmorPoints = PlayerUtils.evaluateAttributeModifiers(baseArmorPointModifiers);
        double baseArmorToughness = PlayerUtils.evaluateAttributeModifiers(baseArmorToughnessModifiers);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return new ArmorStats(baseArmorPoints, baseArmorToughness);
        }
        Multimap modifiers = meta.getAttributeModifiers(slot);
        if (modifiers.isEmpty()) {
            new ArmorStats(baseArmorPoints, baseArmorToughness);
        }
        Collection metaArmorPointModifiers = modifiers.get((Object)Attribute.ARMOR);
        Collection metaArmorToughnessModifiers = modifiers.get((Object)Attribute.ARMOR_TOUGHNESS);
        Collection combinedArmorPointModifiers = Stream.concat(baseArmorPointModifiers.stream(), metaArmorPointModifiers.stream().filter(mod -> !mod.getKey().getKey().equalsIgnoreCase("armor." + key))).collect(Collectors.toSet());
        Collection combinedArmorToughnessModifiers = Stream.concat(baseArmorToughnessModifiers.stream(), metaArmorToughnessModifiers.stream().filter(mod -> !mod.getKey().getKey().equalsIgnoreCase("armor." + key))).collect(Collectors.toSet());
        double combinedArmorPoints = PlayerUtils.evaluateAttributeModifiers(combinedArmorPointModifiers);
        double combinedArmorToughness = PlayerUtils.evaluateAttributeModifiers(combinedArmorToughnessModifiers);
        return new ArmorStats(combinedArmorPoints, combinedArmorToughness);
    }

    private static double evaluateAttributeModifiers(Collection<AttributeModifier> modifiers) {
        double value = 0.0;
        double addScalar = 0.0;
        ArrayList<Double> multiplyScalar1 = new ArrayList<Double>();
        for (AttributeModifier modifier : modifiers) {
            switch (modifier.getOperation()) {
                case ADD_NUMBER: {
                    value += modifier.getAmount();
                    break;
                }
                case ADD_SCALAR: {
                    addScalar += modifier.getAmount();
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    multiplyScalar1.add(modifier.getAmount());
                }
            }
        }
        value *= 1.0 + addScalar;
        Iterator<Object> iterator = multiplyScalar1.iterator();
        while (iterator.hasNext()) {
            double m = (Double)iterator.next();
            value *= 1.0 + m;
        }
        return value;
    }

    public record ArmorStats(double armorPoints, double armorToughness) {
    }
}

