/*
 * Decompiled with CFR 0.152.
 */
package locationalArmorAddon.core;

import bodyhealth.core.BodyPart;
import locationalArmorAddon.Main;
import locationalArmorAddon.math.DamageCalculator;
import locationalArmorAddon.util.PlayerUtils;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Player;

public class BodyPartDamage {
    public DamageType DAMAGE_TYPE;
    public double BASE_DAMAGE;
    public double PRE_EFFECT_DAMAGE;
    public double PRE_ENCHANTMENT_DAMAGE;
    public double PRE_ARMOR_DAMAGE;
    public double EFFECT_DAMAGE_ABSORPTION;
    public double LOCAL_ENCHANTMENT_ABSORPTION;
    public double TOTAL_ENCHANTMENT_ABSORPTION;
    public double LOCAL_ARMOR_ABSORPTION;
    public double TOTAL_ARMOR_ABSORPTION;
    public double EFFECT_DAMAGE_REDUCTION_RATIO;
    public double LOCAL_ENCHANTMENT_REDUCTION_RATIO;
    public double TOTAL_ENCHANTMENT_REDUCTION_RATIO;
    public double LOCAL_ARMOR_REDUCTION_RATIO;
    public double TOTAL_ARMOR_REDUCTION_RATIO;

    public BodyPartDamage(double baseDamage, DamageType damageType, Player player, BodyPart bodyPart, int breachLevel) {
        Main.debug().logDev("");
        Main.debug().logDev(player.getName() + "'s " + bodyPart.name() + " received " + baseDamage + " damage (type " + damageType.getKey().getKey().toUpperCase() + ") with breach level " + breachLevel);
        this.DAMAGE_TYPE = damageType;
        this.BASE_DAMAGE = baseDamage;
        this.PRE_EFFECT_DAMAGE = DamageCalculator.reverseEffectDamageReduction(this.BASE_DAMAGE, this.DAMAGE_TYPE, PlayerUtils.getResistanceLevel(player));
        this.EFFECT_DAMAGE_ABSORPTION = this.PRE_EFFECT_DAMAGE - this.BASE_DAMAGE;
        this.EFFECT_DAMAGE_REDUCTION_RATIO = DamageCalculator.getEffectDamageReductionRatio(this.DAMAGE_TYPE, PlayerUtils.getResistanceLevel(player));
        this.PRE_ENCHANTMENT_DAMAGE = DamageCalculator.reverseEnchantmentDamageReduction(this.PRE_EFFECT_DAMAGE, this.DAMAGE_TYPE, PlayerUtils.getTotalEnchantmentLevels(player));
        this.TOTAL_ENCHANTMENT_ABSORPTION = this.PRE_ENCHANTMENT_DAMAGE - this.PRE_EFFECT_DAMAGE;
        this.TOTAL_ENCHANTMENT_REDUCTION_RATIO = DamageCalculator.getEnchantmentDamageReductionRatio(this.DAMAGE_TYPE, PlayerUtils.getTotalEnchantmentLevels(player));
        this.LOCAL_ENCHANTMENT_REDUCTION_RATIO = DamageCalculator.getEnchantmentDamageReductionRatio(this.DAMAGE_TYPE, PlayerUtils.getLocalEnchantmentLevels(player, bodyPart));
        this.LOCAL_ENCHANTMENT_ABSORPTION = this.PRE_ENCHANTMENT_DAMAGE - DamageCalculator.applyEnchantmentDamageReduction(this.PRE_ENCHANTMENT_DAMAGE, this.DAMAGE_TYPE, PlayerUtils.getLocalEnchantmentLevels(player, bodyPart));
        this.PRE_ARMOR_DAMAGE = DamageCalculator.reverseArmorDamageReduction(this.PRE_ENCHANTMENT_DAMAGE, this.DAMAGE_TYPE, PlayerUtils.getTotalArmorStats(player), breachLevel);
        this.TOTAL_ARMOR_ABSORPTION = this.PRE_ARMOR_DAMAGE - this.PRE_ENCHANTMENT_DAMAGE;
        this.TOTAL_ARMOR_REDUCTION_RATIO = DamageCalculator.getArmorDamageReductionRatio(this.PRE_ARMOR_DAMAGE, this.DAMAGE_TYPE, PlayerUtils.getTotalArmorStats(player), breachLevel);
        this.LOCAL_ARMOR_REDUCTION_RATIO = DamageCalculator.getArmorDamageReductionRatio(this.PRE_ARMOR_DAMAGE, this.DAMAGE_TYPE, PlayerUtils.getLocalArmorStats(player, bodyPart), breachLevel);
        this.LOCAL_ARMOR_ABSORPTION = this.PRE_ARMOR_DAMAGE - DamageCalculator.applyArmorDamageReduction(this.PRE_ARMOR_DAMAGE, this.DAMAGE_TYPE, PlayerUtils.getLocalArmorStats(player, bodyPart), breachLevel);
        Main.debug().logDev("");
        Main.debug().logDev("BASE_DAMAGE: " + this.BASE_DAMAGE);
        Main.debug().logDev("PRE_EFFECT_DAMAGE: " + this.PRE_EFFECT_DAMAGE);
        Main.debug().logDev("EFFECT_DAMAGE_ABSORPTION: " + this.EFFECT_DAMAGE_ABSORPTION);
        Main.debug().logDev("EFFECT_DAMAGE_REDUCTION_RATIO: " + this.EFFECT_DAMAGE_REDUCTION_RATIO);
        Main.debug().logDev("PRE_ENCHANTMENT_DAMAGE: " + this.PRE_ENCHANTMENT_DAMAGE);
        Main.debug().logDev("TOTAL_ENCHANTMENT_ABSORPTION: " + this.TOTAL_ENCHANTMENT_ABSORPTION);
        Main.debug().logDev("TOTAL_ENCHANTMENT_REDUCTION_RATIO: " + this.TOTAL_ENCHANTMENT_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ENCHANTMENT_REDUCTION_RATIO: " + this.LOCAL_ENCHANTMENT_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ENCHANTMENT_ABSORPTION: " + this.LOCAL_ENCHANTMENT_ABSORPTION);
        Main.debug().logDev("PRE_ARMOR_DAMAGE: " + this.PRE_ARMOR_DAMAGE);
        Main.debug().logDev("TOTAL_ARMOR_ABSORPTION: " + this.TOTAL_ARMOR_ABSORPTION);
        Main.debug().logDev("TOTAL_ARMOR_REDUCTION_RATIO: " + this.TOTAL_ARMOR_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ARMOR_REDUCTION_RATIO: " + this.LOCAL_ARMOR_REDUCTION_RATIO);
        Main.debug().logDev("LOCAL_ARMOR_ABSORPTION: " + this.LOCAL_ARMOR_ABSORPTION);
        Main.debug().logDev("");
    }
}

