/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shadowsreborn.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WetFloorSignBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public WetFloorSignBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SCAFFOLDING).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).instrument(NoteBlockInstrument.HAT));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)WetFloorSignBlock.box((double)11.0, (double)-1.0, (double)4.4, (double)13.0, (double)1.0, (double)5.4), (VoxelShape[])new VoxelShape[]{WetFloorSignBlock.box((double)3.0, (double)-1.0, (double)4.4, (double)5.0, (double)1.0, (double)5.4), WetFloorSignBlock.box((double)3.0, (double)1.0, (double)4.4, (double)13.0, (double)13.0, (double)5.4), WetFloorSignBlock.box((double)3.0, (double)-1.0, (double)10.7, (double)5.0, (double)1.0, (double)11.7), WetFloorSignBlock.box((double)11.0, (double)-1.0, (double)10.7, (double)13.0, (double)1.0, (double)11.7), WetFloorSignBlock.box((double)3.0, (double)1.0, (double)10.7, (double)13.0, (double)13.0, (double)11.7)});
            case Direction.NORTH -> Shapes.or((VoxelShape)WetFloorSignBlock.box((double)3.0, (double)-1.0, (double)10.6, (double)5.0, (double)1.0, (double)11.6), (VoxelShape[])new VoxelShape[]{WetFloorSignBlock.box((double)11.0, (double)-1.0, (double)10.6, (double)13.0, (double)1.0, (double)11.6), WetFloorSignBlock.box((double)3.0, (double)1.0, (double)10.6, (double)13.0, (double)13.0, (double)11.6), WetFloorSignBlock.box((double)11.0, (double)-1.0, (double)4.3, (double)13.0, (double)1.0, (double)5.3), WetFloorSignBlock.box((double)3.0, (double)-1.0, (double)4.3, (double)5.0, (double)1.0, (double)5.3), WetFloorSignBlock.box((double)3.0, (double)1.0, (double)4.3, (double)13.0, (double)13.0, (double)5.3)});
            case Direction.EAST -> Shapes.or((VoxelShape)WetFloorSignBlock.box((double)4.4, (double)-1.0, (double)3.0, (double)5.4, (double)1.0, (double)5.0), (VoxelShape[])new VoxelShape[]{WetFloorSignBlock.box((double)4.4, (double)-1.0, (double)11.0, (double)5.4, (double)1.0, (double)13.0), WetFloorSignBlock.box((double)4.4, (double)1.0, (double)3.0, (double)5.4, (double)13.0, (double)13.0), WetFloorSignBlock.box((double)10.7, (double)-1.0, (double)11.0, (double)11.7, (double)1.0, (double)13.0), WetFloorSignBlock.box((double)10.7, (double)-1.0, (double)3.0, (double)11.7, (double)1.0, (double)5.0), WetFloorSignBlock.box((double)10.7, (double)1.0, (double)3.0, (double)11.7, (double)13.0, (double)13.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)WetFloorSignBlock.box((double)10.6, (double)-1.0, (double)11.0, (double)11.6, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[]{WetFloorSignBlock.box((double)10.6, (double)-1.0, (double)3.0, (double)11.6, (double)1.0, (double)5.0), WetFloorSignBlock.box((double)10.6, (double)1.0, (double)3.0, (double)11.6, (double)13.0, (double)13.0), WetFloorSignBlock.box((double)4.3, (double)-1.0, (double)3.0, (double)5.3, (double)1.0, (double)5.0), WetFloorSignBlock.box((double)4.3, (double)-1.0, (double)11.0, (double)5.3, (double)1.0, (double)13.0), WetFloorSignBlock.box((double)4.3, (double)1.0, (double)3.0, (double)5.3, (double)13.0, (double)13.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

