/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.serialization;

import java.io.File;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializer;
import net.thenextlvl.nbt.serialization.TagSerializer;
import net.thenextlvl.nbt.serialization.adapter.AddressAdapter;
import net.thenextlvl.nbt.serialization.adapter.BooleanAdapter;
import net.thenextlvl.nbt.serialization.adapter.ByteAdapter;
import net.thenextlvl.nbt.serialization.adapter.DoubleAdapter;
import net.thenextlvl.nbt.serialization.adapter.DurationAdapter;
import net.thenextlvl.nbt.serialization.adapter.FileAdapter;
import net.thenextlvl.nbt.serialization.adapter.FloatAdapter;
import net.thenextlvl.nbt.serialization.adapter.IntegerAdapter;
import net.thenextlvl.nbt.serialization.adapter.LongAdapter;
import net.thenextlvl.nbt.serialization.adapter.PathAdapter;
import net.thenextlvl.nbt.serialization.adapter.ShortAdapter;
import net.thenextlvl.nbt.serialization.adapter.StringAdapter;
import net.thenextlvl.nbt.serialization.adapter.UUIDAdapter;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class SimpleNBT
implements NBT {
    private final SerializationRegistry registry;

    private SimpleNBT(SerializationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <T> T deserialize(Tag tag, Class<T> type) throws ParserException {
        TagDeserializer<?> deserializer = this.registry.hierarchyDeserializers.get(type);
        if (deserializer != null) {
            return (T)deserializer.deserialize(tag, this);
        }
        return (T)this.registry.hierarchyDeserializers.entrySet().stream().filter(entry -> type.isAssignableFrom((Class)entry.getKey())).findAny().map(entry -> ((TagDeserializer)entry.getValue()).deserialize(tag, this)).orElseGet(() -> this.deserialize(tag, (Type)type));
    }

    @Override
    public <T> T deserialize(Tag tag, Type type) throws ParserException {
        TagDeserializer<?> deserializer = this.registry.deserializers.get(type);
        if (deserializer != null) {
            return (T)deserializer.deserialize(tag, this);
        }
        throw new ParserException("No tag deserializer registered for type: " + String.valueOf(type));
    }

    @Override
    public Tag serialize(Object object) throws ParserException {
        return this.serialize(object, object.getClass());
    }

    @Override
    public Tag serialize(Object object, Class<?> type) throws ParserException {
        TagSerializer<?> serializer = this.registry.hierarchySerializers.get(object.getClass());
        if (serializer != null) {
            return serializer.serialize(object, this);
        }
        return this.registry.hierarchySerializers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(object)).findAny().map(entry -> (TagSerializer)entry.getValue()).map(value -> value.serialize(object, this)).orElseGet(() -> this.serialize(object, (Type)object.getClass()));
    }

    @Override
    public Tag serialize(Object object, Type type) throws ParserException {
        TagSerializer<?> serializer = this.registry.serializers.get(type);
        if (serializer != null) {
            return serializer.serialize(object, this);
        }
        throw new ParserException("No tag serializer registered for type: " + String.valueOf(type));
    }

    private record SerializationRegistry(Map<Class<?>, TagDeserializer<?>> hierarchyDeserializers, Map<Class<?>, TagSerializer<?>> hierarchySerializers, Map<Type, TagDeserializer<?>> deserializers, Map<Type, TagSerializer<?>> serializers) {
        public SerializationRegistry() {
            this(new HashMap(), new HashMap(), new HashMap(), new HashMap());
            this.registerTypeAdapter((Type)((Object)Boolean.class), BooleanAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Byte.class), ByteAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Double.class), DoubleAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Duration.class), DurationAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)File.class), FileAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Float.class), FloatAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)InetSocketAddress.class), AddressAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Integer.class), IntegerAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Long.class), LongAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Path.class), PathAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Short.class), ShortAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)String.class), StringAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)UUID.class), UUIDAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Boolean.TYPE, BooleanAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Byte.TYPE, ByteAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Double.TYPE, DoubleAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Float.TYPE, FloatAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Integer.TYPE, IntegerAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Long.TYPE, LongAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Short.TYPE, ShortAdapter.INSTANCE);
        }

        public void registerTypeHierarchyAdapter(Class<?> clazz, TagAdapter<?> adapter) {
            this.hierarchyDeserializers.put(clazz, adapter);
            this.hierarchySerializers.put(clazz, adapter);
        }

        public void registerTypeHierarchyAdapter(Class<?> clazz, TagDeserializer<?> deserializer) {
            this.hierarchyDeserializers.put(clazz, deserializer);
        }

        public void registerTypeHierarchyAdapter(Class<?> clazz, TagSerializer<?> serializer) {
            this.hierarchySerializers.put(clazz, serializer);
        }

        public void registerTypeAdapter(Type type, TagAdapter<?> adapter) {
            this.deserializers.put(type, adapter);
            this.serializers.put(type, adapter);
        }

        public void registerTypeAdapter(Type type, TagDeserializer<?> deserializer) {
            this.deserializers.put(type, deserializer);
        }

        public void registerTypeAdapter(Type type, TagSerializer<?> serializer) {
            this.serializers.put(type, serializer);
        }

        public SerializationRegistry immutableCopy() {
            return new SerializationRegistry(Map.copyOf(this.hierarchyDeserializers), Map.copyOf(this.hierarchySerializers), Map.copyOf(this.deserializers), Map.copyOf(this.serializers));
        }
    }

    static final class Builder
    implements NBT.Builder {
        private final SerializationRegistry registry = new SerializationRegistry();

        Builder() {
        }

        @Override
        public <T> NBT.Builder registerTypeHierarchyAdapter(Class<?> type, TagAdapter<T> adapter) {
            this.registry.registerTypeHierarchyAdapter(type, adapter);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeHierarchyAdapter(Class<?> type, TagDeserializer<T> deserializer) {
            this.registry.registerTypeHierarchyAdapter(type, deserializer);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeHierarchyAdapter(Class<?> type, TagSerializer<T> serializer) {
            this.registry.registerTypeHierarchyAdapter(type, serializer);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeAdapter(Type type, TagAdapter<T> adapter) {
            this.registry.registerTypeAdapter(type, adapter);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeAdapter(Type type, TagDeserializer<T> deserializer) {
            this.registry.registerTypeAdapter(type, deserializer);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeAdapter(Type type, TagSerializer<T> serializer) {
            this.registry.registerTypeAdapter(type, serializer);
            return this;
        }

        @Override
        public NBT build() {
            return new SimpleNBT(this.registry.immutableCopy());
        }
    }
}

