/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.adapter.other;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.flag.Flag;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class FlagsAdapter
implements TagAdapter<Map<Flag<?>, Object>> {
    private final ProtectPlugin plugin;

    public FlagsAdapter(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Map<Flag<?>, @Nullable Object> deserialize(Tag tag, TagDeserializationContext context) {
        CompoundTag compound = tag.getAsCompound();
        HashMap flags = new HashMap();
        compound.forEach((key, value) -> {
            Key namespace = Key.key((String)key);
            Flag flag = this.plugin.flagRegistry().getFlag(namespace).orElse(null);
            if (flag != null) {
                flags.put(flag, context.deserialize((Tag)value, flag.type()));
            } else {
                this.plugin.getComponentLogger().error("Unknown flag: {}", key);
            }
        });
        return flags;
    }

    @Override
    public Tag serialize(Map<Flag<?>, @Nullable Object> flags, TagSerializationContext context) {
        CompoundTag tag = CompoundTag.empty();
        flags.forEach((flag, value) -> {
            if (value == null) {
                return;
            }
            Tag serialized = context.serialize(value, flag.type());
            tag.add(flag.key().asString(), serialized);
        });
        return tag;
    }
}

