/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.area;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.thenextlvl.nbt.serialization.TagSerializable;
import net.thenextlvl.protect.area.Container;
import net.thenextlvl.protect.area.DataContainer;
import net.thenextlvl.protect.flag.FlagProvider;
import org.bukkit.Server;
import org.bukkit.World;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Area
extends Container,
FlagProvider,
Comparable<Area>,
TagSerializable,
DataContainer {
    @Contract(value=" -> new")
    public LinkedHashSet<Area> getParents();

    @Contract(pure=true)
    public Optional<Area> getParent();

    @Contract(pure=true)
    public Optional<UUID> getOwner();

    @Contract(pure=true)
    public Server getServer();

    @Contract(pure=true)
    public @Unmodifiable Set<UUID> getMembers();

    @Contract(pure=true)
    public String getName();

    @Contract(pure=true)
    public World getWorld();

    @Contract(pure=true)
    public File getDataFolder();

    @Contract(pure=true)
    public File getFile();

    @Contract(pure=true)
    public File getFallbackFile();

    @Contract(mutates="this")
    public boolean addMember(UUID var1);

    @Contract(pure=true)
    public boolean canInteract(Area var1);

    @Contract(pure=true)
    public boolean isMember(UUID var1);

    @Contract(pure=true)
    public boolean isPermitted(UUID var1);

    @Contract(mutates="this")
    public boolean removeMember(UUID var1);

    @Contract(mutates="this")
    public boolean setOwner(@Nullable UUID var1);

    @Contract(mutates="this")
    public boolean setPriority(int var1);

    @Contract(pure=true)
    public int getPriority();

    @Contract(mutates="this")
    public void setMembers(Set<UUID> var1);
}

