/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sk89q.worldedit.WorldEditException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.command.argument.RegionizedAreaArgumentType;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class AreaSchematicCommand {
    AreaSchematicCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"schematic").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic"))).then(AreaSchematicCommand.delete(plugin))).then(AreaSchematicCommand.load(plugin))).then(AreaSchematicCommand.save(plugin));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> delete(ProtectPlugin plugin) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic.delete"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin, area -> area.getSchematic().exists())).executes(context -> AreaSchematicCommand.delete((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> load(ProtectPlugin plugin) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"load").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic.load"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin, area -> area.getSchematic().exists())).executes(context -> AreaSchematicCommand.load((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> save(ProtectPlugin plugin) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"save").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic.save"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin)).executes(context -> AreaSchematicCommand.save((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static int delete(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        String message = area.deleteSchematic() ? "area.schematic.delete.success" : "area.schematic.delete.failed";
        plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematic().getName())});
        return 1;
    }

    private static int load(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        if (area.isTooBig()) {
            plugin.bundle().sendMessage((Audience)sender, "area.warning.size");
        }
        boolean load = false;
        try {
            load = area.loadSchematic();
        }
        catch (WorldEditException | IOException e) {
            plugin.getComponentLogger().error("Failed to load area schematic", e);
        }
        String message = load ? "area.schematic.load.success" : "area.schematic.load.failed";
        plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematic().getName())});
        return 1;
    }

    private static int save(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        if (area.isTooBig()) {
            plugin.bundle().sendMessage((Audience)sender, "area.warning.size");
        }
        try {
            area.saveSchematic();
            plugin.bundle().sendMessage((Audience)sender, "area.schematic.save.success", new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematic().getName()), Formatter.number((String)"size", (Number)(area.getSchematic().length() / 1024L))});
        }
        catch (WorldEditException | IOException e) {
            plugin.bundle().sendMessage((Audience)sender, "area.schematic.save.failed", new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematic().getName())});
            plugin.getComponentLogger().error("Failed dto save area schematic", e);
        }
        return 1;
    }
}

