/*
 * Decompiled with CFR 0.152.
 */
package net.quantum.hoglinfixmod.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class CrimsonTemptGoal
extends Goal {
    private final PathfinderMob mob;
    private final double speed;
    private final double radius;
    private Player targetPlayer;
    private int delayTicks = 0;
    private boolean startedRunning = false;

    public CrimsonTemptGoal(PathfinderMob mob, double speed, double radius) {
        this.mob = mob;
        this.speed = speed;
        this.radius = radius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private static boolean playerHoldsCrimson(Player player) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        return main.m_150930_(Items.f_41954_) || off.m_150930_(Items.f_41954_);
    }

    public boolean m_8036_() {
        if (this.delayTicks > 0) {
            --this.delayTicks;
            return false;
        }
        Level world = this.mob.m_9236_();
        List players = world.m_6443_(Player.class, this.mob.m_20191_().m_82400_(this.radius), CrimsonTemptGoal::playerHoldsCrimson);
        if (players.isEmpty()) {
            this.targetPlayer = null;
            return false;
        }
        players.sort(Comparator.comparingDouble(p -> p.m_20280_((Entity)this.mob)));
        this.targetPlayer = (Player)players.get(0);
        this.startedRunning = false;
        return true;
    }

    public boolean m_8045_() {
        if (this.targetPlayer == null) {
            return false;
        }
        if (!CrimsonTemptGoal.playerHoldsCrimson(this.targetPlayer)) {
            this.targetPlayer = null;
            this.delayTicks = 40;
            this.mob.m_21573_().m_26573_();
            this.startedRunning = false;
            return false;
        }
        return this.mob.m_20280_((Entity)this.targetPlayer) <= this.radius * this.radius;
    }

    public void m_8041_() {
        this.targetPlayer = null;
        this.mob.m_21573_().m_26573_();
        this.startedRunning = false;
    }

    public void m_8037_() {
        if (this.targetPlayer != null) {
            this.mob.m_21563_().m_24960_((Entity)this.targetPlayer, 30.0f, 30.0f);
            if (!this.startedRunning) {
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), SoundEvents.f_12241_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.startedRunning = true;
            }
            this.mob.m_21573_().m_5624_((Entity)this.targetPlayer, this.speed);
        }
    }
}

