/*
 * Decompiled with CFR 0.152.
 */
package de.draradech.flowermap;

import de.draradech.flowermap.FlowerMapMain;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10209;
import net.minecraft.class_1041;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_310;
import net.minecraft.class_3175;
import net.minecraft.class_332;
import net.minecraft.class_4638;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_5216;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6580;
import net.minecraft.class_6581;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_7924;

public class FlowerMapRenderer {
    final class_5819 rand_render = class_5819.method_43047();
    final class_5819 rand_text = class_5819.method_43047();
    final class_310 minecraft;
    class_1043 texture = null;
    class_2960 textureLocation;
    class_2960 pointerLocation;
    Map<class_2248, Integer> colorMap = new LinkedHashMap<class_2248, Integer>();
    Map<class_2248, Integer> errorMap = new LinkedHashMap<class_2248, Integer>();
    Thread renderThread;
    boolean textureRendering;
    class_7225.class_7226<class_1959> vanillaBiomes = null;
    class_5216 noise;

    int color(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public FlowerMapRenderer() {
        this.minecraft = class_310.method_1551();
        this.colorMap.put(class_2246.field_10182, this.color(255, 255, 0));
        this.colorMap.put(class_2246.field_10449, this.color(255, 0, 0));
        this.colorMap.put(class_2246.field_10226, this.color(153, 0, 255));
        this.colorMap.put(class_2246.field_10573, this.color(255, 253, 221));
        this.colorMap.put(class_2246.field_10270, this.color(255, 77, 98));
        this.colorMap.put(class_2246.field_10048, this.color(255, 181, 90));
        this.colorMap.put(class_2246.field_10156, this.color(221, 255, 255));
        this.colorMap.put(class_2246.field_10315, this.color(245, 180, 255));
        this.colorMap.put(class_2246.field_10554, this.color(255, 238, 221));
        this.colorMap.put(class_2246.field_9995, this.color(65, 0, 255));
        this.colorMap.put(class_2246.field_10548, this.color(255, 255, 255));
        this.colorMap.put(class_2246.field_10086, this.color(0, 191, 255));
        this.colorMap.put(class_2246.field_42750, this.color(255, 65, 191));
        this.colorMap.put(class_2246.field_55061, this.color(127, 63, 0));
        this.colorMap.put(class_2246.field_55741, this.color(0, 127, 0));
        this.errorMap.put(class_2246.field_10423, this.color(127, 127, 127));
        this.errorMap.put(class_2246.field_10170, this.color(127, 255, 127));
        this.errorMap.put(class_2246.field_10490, this.color(0, 255, 0));
        this.errorMap.put(class_2246.field_10314, this.color(255, 0, 255));
        this.noise = class_5216.method_38476((class_5819)new class_2919((class_5819)new class_5820(2345L)), (class_5216.class_5487)new class_5216.class_5487(0, 1.0, new double[0]));
        this.renderThread = new Thread(this::renderTexture);
        this.textureRendering = false;
        this.renderThread.start();
    }

    class_2561 getFlowerName(class_2248 block) {
        if (this.colorMap.containsKey(block)) {
            return block.method_9518();
        }
        if (block == class_2246.field_10423) {
            return class_2561.method_43470((String)"None");
        }
        if (block == class_2246.field_10490) {
            return class_2561.method_43470((String)"Error: can't get biome");
        }
        if (block == class_2246.field_10314) {
            return class_2561.method_43470((String)"Error: can't get biome key");
        }
        return class_2561.method_43470((String)"Error: unknown flower: ").method_10852((class_2561)block.method_9518());
    }

    void loadVanillaBiomes() {
        class_7225.class_7874 vanillaRegistries = class_7887.method_46817();
        this.vanillaBiomes = vanillaRegistries.method_46762(class_7924.field_41236);
    }

    class_2248 getRandomFlowerAt(class_2338 pos, class_5819 randomSource) {
        class_6880 biomeEntry;
        class_5321 biomeKey;
        if (this.vanillaBiomes == null) {
            this.loadVanillaBiomes();
        }
        if ((biomeKey = (class_5321)(biomeEntry = this.minecraft.field_1724.method_73183().method_23753(pos)).method_40230().orElse(null)) == null) {
            return class_2246.field_10314;
        }
        class_6880.class_6883 vanillaBiomeRef = this.vanillaBiomes.method_46746(biomeKey).orElse(null);
        if (vanillaBiomeRef == null) {
            return class_2246.field_10490;
        }
        class_1959 vanillaBiome = (class_1959)vanillaBiomeRef.comp_349();
        List list = vanillaBiome.method_30970().method_30982();
        if (list.isEmpty()) {
            return class_2246.field_10423;
        }
        int k = randomSource.method_43048(list.size());
        class_4638 config = (class_4638)((class_2975)list.get(k)).comp_333();
        class_3175 flowerMap = (class_3175)((class_2975)((class_6796)config.comp_155().comp_349()).comp_334().comp_349()).comp_333();
        return flowerMap.comp_156().method_23455(this.rand_render, pos).method_26204();
    }

    public void renderPossibleFlowerName(class_332 guiGraphics, class_2248 block, int w, int i) {
        class_2561 flowerName = this.getFlowerName(block);
        guiGraphics.method_27535(this.minecraft.field_1772, flowerName, w - 5 - 256 + 12, 266 + 12 * (i + 3), -1);
    }

    public void renderPossibleFlowerNamesAt(class_2338 pos, int w, class_332 gui) {
        if (this.vanillaBiomes == null) {
            this.loadVanillaBiomes();
        }
        int k = 0;
        class_6880 biomeEntry = this.minecraft.field_1724.method_73183().method_23753(pos);
        class_5321 biomeKey = biomeEntry.method_40230().orElse(null);
        if (biomeKey == null) {
            this.renderPossibleFlowerName(gui, class_2246.field_10314, w, k++);
        } else {
            class_6880.class_6883 vanillaBiomeRef = this.vanillaBiomes.method_46746(biomeKey).orElse(null);
            if (vanillaBiomeRef == null) {
                this.renderPossibleFlowerName(gui, class_2246.field_10490, w, k++);
            } else {
                class_1959 vanillaBiome = (class_1959)vanillaBiomeRef.comp_349();
                List list = vanillaBiome.method_30970().method_30982();
                if (list.isEmpty()) {
                    this.renderPossibleFlowerName(gui, class_2246.field_10423, w, k++);
                } else {
                    for (class_2975 feature : list) {
                        class_4638 config = (class_4638)feature.comp_333();
                        class_3175 flowerMap = (class_3175)((class_2975)((class_6796)config.comp_155().comp_349()).comp_334().comp_349()).comp_333();
                        class_4651 bsp = flowerMap.comp_156();
                        if (bsp instanceof class_6580 || bsp instanceof class_4656) {
                            this.renderPossibleFlowerName(gui, bsp.method_23455(this.rand_text, pos).method_26204(), w, k++);
                            continue;
                        }
                        if (bsp instanceof class_4657) {
                            class_2248 b = bsp.method_23455(this.rand_text, pos).method_26204();
                            if (b == class_2246.field_55741) {
                                this.renderPossibleFlowerName(gui, class_2246.field_55741, w, k++);
                                continue;
                            }
                            if (b == class_2246.field_42750) {
                                this.renderPossibleFlowerName(gui, class_2246.field_42750, w, k++);
                                continue;
                            }
                            this.renderPossibleFlowerName(gui, class_2246.field_10449, w, k++);
                            this.renderPossibleFlowerName(gui, class_2246.field_10182, w, k++);
                            continue;
                        }
                        if (!(bsp instanceof class_6581)) continue;
                        double t = this.noise.method_27406((double)pos.method_10263() * (double)0.005f, (double)pos.method_10264() * (double)0.005f, (double)pos.method_10260() * (double)0.005f);
                        if (t < (double)-0.8f) {
                            this.renderPossibleFlowerName(gui, class_2246.field_10048, w, k++);
                            this.renderPossibleFlowerName(gui, class_2246.field_10270, w, k++);
                            this.renderPossibleFlowerName(gui, class_2246.field_10315, w, k++);
                            this.renderPossibleFlowerName(gui, class_2246.field_10156, w, k++);
                            continue;
                        }
                        this.renderPossibleFlowerName(gui, class_2246.field_10182, w, k++);
                        this.renderPossibleFlowerName(gui, class_2246.field_10449, w, k++);
                        this.renderPossibleFlowerName(gui, class_2246.field_10573, w, k++);
                        this.renderPossibleFlowerName(gui, class_2246.field_10554, w, k++);
                        this.renderPossibleFlowerName(gui, class_2246.field_9995, w, k++);
                    }
                }
            }
        }
    }

    void renderTexture() {
        while (true) {
            if (this.textureRendering) {
                int px = this.minecraft.field_1724.method_31477();
                int py = this.minecraft.field_1724.method_31478();
                int pz = this.minecraft.field_1724.method_31479();
                class_2338.class_2339 pos = new class_2338.class_2339(0, FlowerMapMain.config.fixedY, 0);
                if (FlowerMapMain.config.dynamic) {
                    pos.method_33098(py);
                }
                for (int x = 0; x < 256; ++x) {
                    for (int z = 0; z < 256; ++z) {
                        pos.method_33097(px + x - 128);
                        pos.method_33099(pz + z - 128);
                        class_2248 block = this.getRandomFlowerAt((class_2338)pos, this.rand_render);
                        this.texture.method_4525().method_61941(x, z, this.colorMap.getOrDefault(block, this.errorMap.getOrDefault(block, this.errorMap.get(class_2246.field_10170))).intValue());
                    }
                }
                this.textureRendering = false;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void render(class_332 guiGraphics) {
        if (!FlowerMapMain.config.enabled) {
            return;
        }
        class_10209.method_64146().method_15396("flowermap");
        if (this.texture == null) {
            this.texture = new class_1043((String)null, 256, 256, false);
            this.texture.method_4527(false, false);
            this.pointerLocation = class_2960.method_60655((String)"flowermap", (String)"pointer.png");
            this.textureLocation = class_2960.method_60655((String)"flowermap", (String)"dynamic_map");
            this.minecraft.method_1531().method_4616(this.textureLocation, (class_1044)this.texture);
        }
        class_1041 window = this.minecraft.method_22683();
        float width = (float)window.method_4489() / FlowerMapMain.config.scale;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().identity();
        guiGraphics.method_51448().scale(FlowerMapMain.config.scale / (float)window.method_4495());
        if (!this.textureRendering) {
            class_10209.method_64146().method_15396("upload");
            this.texture.method_4524();
            class_10209.method_64146().method_15407();
            this.textureRendering = true;
        }
        guiGraphics.method_25290(class_10799.field_56883, this.textureLocation, (int)width - 256 - 5, 5, 0.0f, 0.0f, 256, 256, 256, 256);
        if (FlowerMapMain.config.dynamic) {
            guiGraphics.method_25303(this.minecraft.field_1772, String.format("Position (xzy): %d, %d, %d (player)", this.minecraft.field_1724.method_31477(), this.minecraft.field_1724.method_31479(), this.minecraft.field_1724.method_31478()), (int)width - 256 - 5, 278, -1);
        } else {
            guiGraphics.method_25303(this.minecraft.field_1772, String.format("Position (xzy): %d, %d, %d (fixed y)", this.minecraft.field_1724.method_31477(), this.minecraft.field_1724.method_31479(), FlowerMapMain.config.fixedY), (int)width - 256 - 5, 278, -1);
        }
        class_2338.class_2339 pos = this.minecraft.field_1724.method_24515().method_25503();
        if (!FlowerMapMain.config.dynamic) {
            pos.method_33098(FlowerMapMain.config.fixedY);
        }
        class_6880 biomeEntry = this.minecraft.field_1724.method_73183().method_23753((class_2338)pos);
        class_5250 biomeName = class_2561.method_43471((String)class_156.method_646((String)"biome", (class_2960)((class_5321)biomeEntry.method_40230().get()).method_29177()));
        guiGraphics.method_27535(this.minecraft.field_1772, (class_2561)class_2561.method_43470((String)"Biome: ").method_10852((class_2561)biomeName), (int)width - 5 - 256, 266, -1);
        class_5250 desc = class_2561.method_43470((String)"Possible flowers at this location:");
        guiGraphics.method_27535(this.minecraft.field_1772, (class_2561)desc, (int)width - 256 - 5, 290, -1);
        this.renderPossibleFlowerNamesAt((class_2338)pos, (int)width, guiGraphics);
        if (FlowerMapMain.config.legend) {
            class_10209.method_64146().method_15396("legend");
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().scale(FlowerMapMain.config.legendScale / FlowerMapMain.config.scale);
            int i = 0;
            for (Map.Entry<class_2248, Integer> e : this.colorMap.entrySet()) {
                guiGraphics.method_25294(5, 5 + i * 12, 15, 15 + i * 12, e.getValue().intValue());
                guiGraphics.method_27535(this.minecraft.field_1772, this.getFlowerName(e.getKey()), 17, 7 + i++ * 12, -1);
            }
            guiGraphics.method_51448().popMatrix();
            class_10209.method_64146().method_15407();
        }
        guiGraphics.method_51448().translate((float)((int)width - 256 - 5 + 128), 133.0f);
        guiGraphics.method_51448().rotate((float)Math.PI / 180 * (this.minecraft.field_1724.method_36454() + 180.0f));
        guiGraphics.method_25290(class_10799.field_56883, this.pointerLocation, -8, -9, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.method_51448().popMatrix();
        class_10209.method_64146().method_15407();
    }
}

