/*
 * Decompiled with CFR 0.152.
 */
package de.draradech.flowermap;

import de.draradech.flowermap.FlowerMapConfig;
import de.draradech.flowermap.FlowerMapRenderer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class FlowerMapMain {
    public static final String MODID = "flowermap";
    public static FlowerMapConfig config;
    public static ConfigHolder<FlowerMapConfig> configHolder;
    public static FlowerMapRenderer renderer;
    public static KeyMapping keyToggle;
    public static KeyMapping keyToggleDynamic;
    public static KeyMapping keyIncreaseY;
    public static KeyMapping keyDecreaseY;
    public static KeyMapping keySetY;
    public static KeyMapping.Category keyCategory;

    public static void init() {
        renderer = new FlowerMapRenderer();
        keyCategory = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"keycategory"));
        keyToggle = new KeyMapping("key.flowermap.toggle", 297, keyCategory);
        keyToggleDynamic = new KeyMapping("key.flowermap.toggleDynamic", 332, keyCategory);
        keyIncreaseY = new KeyMapping("key.flowermap.increaseY", 334, keyCategory);
        keyDecreaseY = new KeyMapping("key.flowermap.decreaseY", 333, keyCategory);
        keySetY = new KeyMapping("key.flowermap.setY", 320, keyCategory);
        configHolder = AutoConfig.register(FlowerMapConfig.class, GsonConfigSerializer::new);
        config = (FlowerMapConfig)AutoConfig.getConfigHolder(FlowerMapConfig.class).getConfig();
    }

    public static void render(GuiGraphics guiGraphics) {
        if (keyIncreaseY.consumeClick() && FlowerMapMain.config.enabled && !FlowerMapMain.config.dynamic) {
            FlowerMapMain.config.fixedY = Mth.clamp((int)(FlowerMapMain.config.fixedY + 1), (int)-63, (int)319);
            configHolder.save();
        }
        if (keyDecreaseY.consumeClick() && FlowerMapMain.config.enabled && !FlowerMapMain.config.dynamic) {
            FlowerMapMain.config.fixedY = Mth.clamp((int)(FlowerMapMain.config.fixedY - 1), (int)-63, (int)319);
            configHolder.save();
        }
        if (keySetY.consumeClick() && FlowerMapMain.config.enabled && !FlowerMapMain.config.dynamic) {
            FlowerMapMain.config.fixedY = Minecraft.getInstance().player.getBlockY();
            configHolder.save();
        }
        if (keyToggleDynamic.consumeClick() && FlowerMapMain.config.enabled) {
            FlowerMapMain.config.dynamic = !FlowerMapMain.config.dynamic;
            configHolder.save();
        }
        if (keyToggle.consumeClick()) {
            FlowerMapMain.config.enabled = !FlowerMapMain.config.enabled;
            configHolder.save();
        }
        renderer.render(guiGraphics);
    }
}

