/*
 * Decompiled with CFR 0.152.
 */
package de.draradech.flowermap;

import com.mojang.blaze3d.platform.Window;
import de.draradech.flowermap.FlowerMapMain;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class FlowerMapRenderer {
    final RandomSource rand_render = RandomSource.create();
    final RandomSource rand_text = RandomSource.create();
    final Minecraft minecraft;
    DynamicTexture texture = null;
    ResourceLocation textureLocation;
    ResourceLocation pointerLocation;
    Map<Block, Integer> colorMap = new LinkedHashMap<Block, Integer>();
    Map<Block, Integer> errorMap = new LinkedHashMap<Block, Integer>();
    Thread renderThread;
    boolean textureRendering;
    HolderLookup.RegistryLookup<Biome> vanillaBiomes = null;
    NormalNoise noise;

    int color(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public FlowerMapRenderer() {
        this.minecraft = Minecraft.getInstance();
        this.colorMap.put(Blocks.DANDELION, this.color(255, 255, 0));
        this.colorMap.put(Blocks.POPPY, this.color(255, 0, 0));
        this.colorMap.put(Blocks.ALLIUM, this.color(153, 0, 255));
        this.colorMap.put(Blocks.AZURE_BLUET, this.color(255, 253, 221));
        this.colorMap.put(Blocks.RED_TULIP, this.color(255, 77, 98));
        this.colorMap.put(Blocks.ORANGE_TULIP, this.color(255, 181, 90));
        this.colorMap.put(Blocks.WHITE_TULIP, this.color(221, 255, 255));
        this.colorMap.put(Blocks.PINK_TULIP, this.color(245, 180, 255));
        this.colorMap.put(Blocks.OXEYE_DAISY, this.color(255, 238, 221));
        this.colorMap.put(Blocks.CORNFLOWER, this.color(65, 0, 255));
        this.colorMap.put(Blocks.LILY_OF_THE_VALLEY, this.color(255, 255, 255));
        this.colorMap.put(Blocks.BLUE_ORCHID, this.color(0, 191, 255));
        this.colorMap.put(Blocks.PINK_PETALS, this.color(255, 65, 191));
        this.colorMap.put(Blocks.CLOSED_EYEBLOSSOM, this.color(127, 63, 0));
        this.colorMap.put(Blocks.WILDFLOWERS, this.color(0, 127, 0));
        this.errorMap.put(Blocks.GRAY_WOOL, this.color(127, 127, 127));
        this.errorMap.put(Blocks.GREEN_WOOL, this.color(127, 255, 127));
        this.errorMap.put(Blocks.YELLOW_WOOL, this.color(0, 255, 0));
        this.errorMap.put(Blocks.RED_WOOL, this.color(255, 0, 255));
        this.noise = NormalNoise.create((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(0, 1.0, new double[0]));
        this.renderThread = new Thread(this::renderTexture);
        this.textureRendering = false;
        this.renderThread.start();
    }

    Component getFlowerName(Block block) {
        if (this.colorMap.containsKey(block)) {
            return block.getName();
        }
        if (block == Blocks.GRAY_WOOL) {
            return Component.literal((String)"None");
        }
        if (block == Blocks.YELLOW_WOOL) {
            return Component.literal((String)"Error: can't get biome");
        }
        if (block == Blocks.RED_WOOL) {
            return Component.literal((String)"Error: can't get biome key");
        }
        return Component.literal((String)"Error: unknown flower: ").append((Component)block.getName());
    }

    void loadVanillaBiomes() {
        HolderLookup.Provider vanillaRegistries = VanillaRegistries.createLookup();
        this.vanillaBiomes = vanillaRegistries.lookupOrThrow(Registries.BIOME);
    }

    Block getRandomFlowerAt(BlockPos pos, RandomSource randomSource) {
        Holder biomeEntry;
        ResourceKey biomeKey;
        if (this.vanillaBiomes == null) {
            this.loadVanillaBiomes();
        }
        if ((biomeKey = (ResourceKey)(biomeEntry = this.minecraft.player.level().getBiome(pos)).unwrapKey().orElse(null)) == null) {
            return Blocks.RED_WOOL;
        }
        Holder.Reference vanillaBiomeRef = this.vanillaBiomes.get(biomeKey).orElse(null);
        if (vanillaBiomeRef == null) {
            return Blocks.YELLOW_WOOL;
        }
        Biome vanillaBiome = (Biome)vanillaBiomeRef.value();
        List list = vanillaBiome.getGenerationSettings().getFlowerFeatures();
        if (list.isEmpty()) {
            return Blocks.GRAY_WOOL;
        }
        int k = randomSource.nextInt(list.size());
        RandomPatchConfiguration config = (RandomPatchConfiguration)((ConfiguredFeature)list.get(k)).config();
        SimpleBlockConfiguration flowerMap = (SimpleBlockConfiguration)((ConfiguredFeature)((PlacedFeature)config.feature().value()).feature().value()).config();
        return flowerMap.toPlace().getState(this.rand_render, pos).getBlock();
    }

    public void renderPossibleFlowerName(GuiGraphics guiGraphics, Block block, int w, int i) {
        Component flowerName = this.getFlowerName(block);
        guiGraphics.drawString(this.minecraft.font, flowerName, w - 5 - 256 + 12, 266 + 12 * (i + 3), -1);
    }

    public void renderPossibleFlowerNamesAt(BlockPos pos, int w, GuiGraphics gui) {
        if (this.vanillaBiomes == null) {
            this.loadVanillaBiomes();
        }
        int k = 0;
        Holder biomeEntry = this.minecraft.player.level().getBiome(pos);
        ResourceKey biomeKey = biomeEntry.unwrapKey().orElse(null);
        if (biomeKey == null) {
            this.renderPossibleFlowerName(gui, Blocks.RED_WOOL, w, k++);
        } else {
            Holder.Reference vanillaBiomeRef = this.vanillaBiomes.get(biomeKey).orElse(null);
            if (vanillaBiomeRef == null) {
                this.renderPossibleFlowerName(gui, Blocks.YELLOW_WOOL, w, k++);
            } else {
                Biome vanillaBiome = (Biome)vanillaBiomeRef.value();
                List list = vanillaBiome.getGenerationSettings().getFlowerFeatures();
                if (list.isEmpty()) {
                    this.renderPossibleFlowerName(gui, Blocks.GRAY_WOOL, w, k++);
                } else {
                    for (ConfiguredFeature feature : list) {
                        RandomPatchConfiguration config = (RandomPatchConfiguration)feature.config();
                        SimpleBlockConfiguration flowerMap = (SimpleBlockConfiguration)((ConfiguredFeature)((PlacedFeature)config.feature().value()).feature().value()).config();
                        BlockStateProvider bsp = flowerMap.toPlace();
                        if (bsp instanceof NoiseProvider || bsp instanceof SimpleStateProvider) {
                            this.renderPossibleFlowerName(gui, bsp.getState(this.rand_text, pos).getBlock(), w, k++);
                            continue;
                        }
                        if (bsp instanceof WeightedStateProvider) {
                            Block b = bsp.getState(this.rand_text, pos).getBlock();
                            if (b == Blocks.WILDFLOWERS) {
                                this.renderPossibleFlowerName(gui, Blocks.WILDFLOWERS, w, k++);
                                continue;
                            }
                            if (b == Blocks.PINK_PETALS) {
                                this.renderPossibleFlowerName(gui, Blocks.PINK_PETALS, w, k++);
                                continue;
                            }
                            this.renderPossibleFlowerName(gui, Blocks.POPPY, w, k++);
                            this.renderPossibleFlowerName(gui, Blocks.DANDELION, w, k++);
                            continue;
                        }
                        if (!(bsp instanceof NoiseThresholdProvider)) continue;
                        double t = this.noise.getValue((double)pos.getX() * (double)0.005f, (double)pos.getY() * (double)0.005f, (double)pos.getZ() * (double)0.005f);
                        if (t < (double)-0.8f) {
                            this.renderPossibleFlowerName(gui, Blocks.ORANGE_TULIP, w, k++);
                            this.renderPossibleFlowerName(gui, Blocks.RED_TULIP, w, k++);
                            this.renderPossibleFlowerName(gui, Blocks.PINK_TULIP, w, k++);
                            this.renderPossibleFlowerName(gui, Blocks.WHITE_TULIP, w, k++);
                            continue;
                        }
                        this.renderPossibleFlowerName(gui, Blocks.DANDELION, w, k++);
                        this.renderPossibleFlowerName(gui, Blocks.POPPY, w, k++);
                        this.renderPossibleFlowerName(gui, Blocks.AZURE_BLUET, w, k++);
                        this.renderPossibleFlowerName(gui, Blocks.OXEYE_DAISY, w, k++);
                        this.renderPossibleFlowerName(gui, Blocks.CORNFLOWER, w, k++);
                    }
                }
            }
        }
    }

    void renderTexture() {
        while (true) {
            if (this.textureRendering) {
                int px = this.minecraft.player.getBlockX();
                int py = this.minecraft.player.getBlockY();
                int pz = this.minecraft.player.getBlockZ();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, FlowerMapMain.config.fixedY, 0);
                if (FlowerMapMain.config.dynamic) {
                    pos.setY(py);
                }
                for (int x = 0; x < 256; ++x) {
                    for (int z = 0; z < 256; ++z) {
                        pos.setX(px + x - 128);
                        pos.setZ(pz + z - 128);
                        Block block = this.getRandomFlowerAt((BlockPos)pos, this.rand_render);
                        this.texture.getPixels().setPixel(x, z, this.colorMap.getOrDefault(block, this.errorMap.getOrDefault(block, this.errorMap.get(Blocks.GREEN_WOOL))).intValue());
                    }
                }
                this.textureRendering = false;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void render(GuiGraphics guiGraphics) {
        if (!FlowerMapMain.config.enabled) {
            return;
        }
        Profiler.get().push("flowermap");
        if (this.texture == null) {
            this.texture = new DynamicTexture((String)null, 256, 256, false);
            this.texture.setFilter(false, false);
            this.pointerLocation = ResourceLocation.fromNamespaceAndPath((String)"flowermap", (String)"pointer.png");
            this.textureLocation = ResourceLocation.fromNamespaceAndPath((String)"flowermap", (String)"dynamic_map");
            this.minecraft.getTextureManager().register(this.textureLocation, (AbstractTexture)this.texture);
        }
        Window window = this.minecraft.getWindow();
        float width = (float)window.getWidth() / FlowerMapMain.config.scale;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().identity();
        guiGraphics.pose().scale(FlowerMapMain.config.scale / (float)window.getGuiScale());
        if (!this.textureRendering) {
            Profiler.get().push("upload");
            this.texture.upload();
            Profiler.get().pop();
            this.textureRendering = true;
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.textureLocation, (int)width - 256 - 5, 5, 0.0f, 0.0f, 256, 256, 256, 256);
        if (FlowerMapMain.config.dynamic) {
            guiGraphics.drawString(this.minecraft.font, String.format("Position (xzy): %d, %d, %d (player)", this.minecraft.player.getBlockX(), this.minecraft.player.getBlockZ(), this.minecraft.player.getBlockY()), (int)width - 256 - 5, 278, -1);
        } else {
            guiGraphics.drawString(this.minecraft.font, String.format("Position (xzy): %d, %d, %d (fixed y)", this.minecraft.player.getBlockX(), this.minecraft.player.getBlockZ(), FlowerMapMain.config.fixedY), (int)width - 256 - 5, 278, -1);
        }
        BlockPos.MutableBlockPos pos = this.minecraft.player.blockPosition().mutable();
        if (!FlowerMapMain.config.dynamic) {
            pos.setY(FlowerMapMain.config.fixedY);
        }
        Holder biomeEntry = this.minecraft.player.level().getBiome((BlockPos)pos);
        MutableComponent biomeName = Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceKey)biomeEntry.unwrapKey().get()).location()));
        guiGraphics.drawString(this.minecraft.font, (Component)Component.literal((String)"Biome: ").append((Component)biomeName), (int)width - 5 - 256, 266, -1);
        MutableComponent desc = Component.literal((String)"Possible flowers at this location:");
        guiGraphics.drawString(this.minecraft.font, (Component)desc, (int)width - 256 - 5, 290, -1);
        this.renderPossibleFlowerNamesAt((BlockPos)pos, (int)width, guiGraphics);
        if (FlowerMapMain.config.legend) {
            Profiler.get().push("legend");
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().scale(FlowerMapMain.config.legendScale / FlowerMapMain.config.scale);
            int i = 0;
            for (Map.Entry<Block, Integer> e : this.colorMap.entrySet()) {
                guiGraphics.fill(5, 5 + i * 12, 15, 15 + i * 12, e.getValue().intValue());
                guiGraphics.drawString(this.minecraft.font, this.getFlowerName(e.getKey()), 17, 7 + i++ * 12, -1);
            }
            guiGraphics.pose().popMatrix();
            Profiler.get().pop();
        }
        guiGraphics.pose().translate((float)((int)width - 256 - 5 + 128), 133.0f);
        guiGraphics.pose().rotate((float)Math.PI / 180 * (this.minecraft.player.getYRot() + 180.0f));
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.pointerLocation, -8, -9, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.pose().popMatrix();
        Profiler.get().pop();
    }
}

