package com.luxof.lapisworks;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment.HeldItemInfo;
import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexItems;

import com.luxof.lapisworks.init.ModItems;
import com.luxof.lapisworks.init.ModPOIs;
import com.luxof.lapisworks.init.ModRecipes;
import com.luxof.lapisworks.init.Patterns;
import com.luxof.lapisworks.init.LapisworksLoot;
import com.luxof.lapisworks.init.ModBlocks;
import com.luxof.lapisworks.init.ModEntities;
import com.luxof.lapisworks.init.ThemConfigFlags;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.mixinsupport.GetStacks;

import static com.luxof.lapisworks.LapisworksIDs.MAINHAND;
import static com.luxof.lapisworks.LapisworksIDs.OFFHAND;
import static com.luxof.lapisworks.init.ThemConfigFlags.allPerWorldShapePatterns;
import static com.luxof.lapisworks.init.ThemConfigFlags.chosenFlags;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

import org.joml.Random;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import vazkii.patchouli.api.PatchouliAPI;

// why is this project actually big?
public class Lapisworks implements ModInitializer {
	private static FrozenPigment BLACK_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7963)), class_156.field_25140);
	private static FrozenPigment BROWN_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7957)), class_156.field_25140);
	private static FrozenPigment BLUE_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7966)), class_156.field_25140);
	private static FrozenPigment CYAN_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7955)), class_156.field_25140);
	private static FrozenPigment GRAY_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7944)), class_156.field_25140);
	private static FrozenPigment GREEN_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7942)), class_156.field_25140);
	private static FrozenPigment LIGHT_BLUE_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7951)), class_156.field_25140);
	private static FrozenPigment LIGHT_GRAY_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7967)), class_156.field_25140);
	private static FrozenPigment LIME_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7961)), class_156.field_25140);
	private static FrozenPigment MAGENTA_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7958)), class_156.field_25140);
	private static FrozenPigment ORANGE_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7946)), class_156.field_25140);
	private static FrozenPigment PINK_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7954)), class_156.field_25140);
	private static FrozenPigment PURPLE_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7945)), class_156.field_25140);
	private static FrozenPigment RED_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7964)), class_156.field_25140);
	private static FrozenPigment WHITE_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7952)), class_156.field_25140);
	private static FrozenPigment YELLOW_FP = new FrozenPigment(new class_1799(HexItems.DYE_PIGMENTS.get(class_1767.field_7947)), class_156.field_25140);

	public static final String MOD_ID = "lapisworks";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static boolean HEXTENDED_INTEROP = false;
	public static boolean HEXICAL_INTEROP = false;

	public static boolean isModLoaded(String modid) { return FabricLoader.getInstance().isModLoaded(modid); }
	/** assumes the mod is actually loaded and that <code>targetVersion</code> doesn't cause an error.
	 * Kurwa eksploduje if wrong? Nah, just gives <code>null</code>.
	 * If true? returns <code>current version - target version</code> */
	@Nullable
	public static Integer verDifference(String modid, String targetVersion) {
		try {
			Version currentVer = FabricLoader.getInstance().getModContainer(modid).get()
				.getMetadata().getVersion();
			Version targetVer = Version.parse(targetVersion);
			return currentVer.compareTo(targetVer);
		} catch (Exception e) {
			return null;
		}
	}

	@Override
	public void onInitialize() {
		boolean anyInterop = false;
        if (isModLoaded("hextended")) {
			HEXTENDED_INTEROP = true;
			anyInterop = true;
            com.luxof.lapisworks.interop.hextended.Lapixtended.initHextendedInterop();
        }
		if (isModLoaded("hexical")) {
			HEXICAL_INTEROP = true;
			anyInterop = true;
			com.luxof.lapisworks.interop.hexical.Lapixical.initHexicalInterop();
		}

		ThemConfigFlags.declareEm();
		ModEntities.questionWhyIMustDoThis();
		Patterns.init();
		ModItems.init_shit();
		LapisworksServer.lockIn();
		ModBlocks.wearASkirt();
		LapisworksLoot.gibLootexclamationmark();
		Mutables.innitBruv();
		ModPOIs.crawlOutOfHell();
		ModRecipes.apologizeForWarcrimes();

        LOGGER.info("Luxof's pet Lapisworks is getting a bit hyperactive.");
		LOGGER.info("\"Lapisworks! Lapis Lapis!\"");
		if (anyInterop) {
			// yknow, i would love to make the Interop category unavailable until mods required exist
			// but what if i keep it right there to garner curiosity and get people to download other addons?
			// prolly won't produce that big of an effect considering Lapisworks isn't that popular
			// but i'll make it be that way anyway, as a sign of goodwill or sumn idfk i just felt like it
			//PatchouliAPI.get().setConfigFlag(
			//	"lapisworks:any_interop",
			//	true
			//)
			LOGGER.info("You have an addon that has interop with Lapisworks loaded?! Oh NOO, it's overstimulated, it's gonna throw up a bunch of content! Look what you've done!");
		} else LOGGER.info("Feed it redstone.");

		;
	}

	public static class_2960 id(String string) {
		return new class_2960(MOD_ID, string);
	}

	public static boolean trinketEquipped(class_1309 entity, class_1792 item) {
		Optional<TrinketComponent> trinkCompOp = TrinketsApi.getTrinketComponent(entity);
		return trinkCompOp.isEmpty() ? false : trinkCompOp.get().isEquipped(item);
	}

	@Nullable
	public static FrozenPigment getPigmentFromDye(class_1767 dye) {
		// if I can't have Map to do it I'll get a function to do it
		switch (dye) {
			case field_7963: return BLACK_FP;
			case field_7957: return BROWN_FP;
			case field_7966: return BLUE_FP;
			case field_7955: return CYAN_FP;
			case field_7944: return GRAY_FP;
			case field_7942: return GREEN_FP;
			case field_7951: return LIGHT_BLUE_FP;
			case field_7967: return LIGHT_GRAY_FP;
			case field_7961: return LIME_FP;
			case field_7958: return MAGENTA_FP;
			case field_7946: return ORANGE_FP;
			case field_7954: return PINK_FP;
			case field_7945: return PURPLE_FP;
			case field_7964: return RED_FP;
			case field_7952: return WHITE_FP;
			case field_7947: return YELLOW_FP;
			default: return null;
		}
	}

	@Nullable
	public static class_1767 getDyeFromPigment(FrozenPigment pigment) {
		// uncommon, that's my excuse
		if (pigment == BLACK_FP) { return class_1767.field_7963; }
		else if (pigment == BROWN_FP) { return class_1767.field_7957; }
		else if (pigment == BLUE_FP) { return class_1767.field_7966; }
		else if (pigment == CYAN_FP) { return class_1767.field_7955; }
		else if (pigment == GRAY_FP) { return class_1767.field_7944; }
		else if (pigment == GREEN_FP) { return class_1767.field_7942; }
		else if (pigment == LIGHT_BLUE_FP) { return class_1767.field_7951; }
		else if (pigment == LIGHT_GRAY_FP) { return class_1767.field_7967; }
		else if (pigment == LIME_FP) { return class_1767.field_7961; }
		else if (pigment == MAGENTA_FP) { return class_1767.field_7958; }
		else if (pigment == ORANGE_FP) { return class_1767.field_7946; }
		else if (pigment == PINK_FP) { return class_1767.field_7954; }
		else if (pigment == PURPLE_FP) { return class_1767.field_7945; }
		else if (pigment == RED_FP) { return class_1767.field_7964; }
		else if (pigment == WHITE_FP) { return class_1767.field_7952; }
		else if (pigment == YELLOW_FP) { return class_1767.field_7947; }
		else { return null; }
	}

	public static double clamp(double num, double min, double max) { return Math.min(Math.max(num, min), max); }
	public static float clamp(float num, float min, float max) { return Math.min(Math.max(num, min), max); }

	/** Computes the seed that will be used to compute per-world pattern shapes from a world seed. */
	public static int pickUsingSeed(long seed) {
		// i'm trusting that org.joml.Random won't change and that java.util.Random will across Java versions
		// (should probably homebrew my own atp)
		Random rng = new Random(seed);
		int sendThisSeed = 0;
		for (int i = -1; i < seed % 13; i++) { // so no one can predict the world seed off this
			sendThisSeed = rng.nextInt(32767);
		}
		return sendThisSeed;
	}

	/** Computes the config flags and selects them for you. */
	public static void pickConfigFlags(int seed) {
		for (String patId : allPerWorldShapePatterns.keySet()) {
			int amountOfPatterns = allPerWorldShapePatterns.get(patId).size();
			// same seed used per pattern
			Random rng = new Random(
				new Random(seed % amountOfPatterns).nextInt(32767)
			);
			int chosen = rng.nextInt(32767) % amountOfPatterns;
			PatchouliAPI.get().setConfigFlag(
				patId + String.valueOf(chosen),
				true
			);
			chosenFlags.put(patId, chosen);
		}
	}

	/** Nulls the config flags for you. */
	public static void nullConfigFlags() {
		LOGGER.info("Nulling config flags.");
		for (String patId : allPerWorldShapePatterns.keySet()) {
			for (int i = 0; i < allPerWorldShapePatterns.get(patId).size(); i++) {
				PatchouliAPI.get().setConfigFlag(
					patId + String.valueOf(i),
					false
				);
			}
			chosenFlags.put(patId, null);
		}
	}

	/** truncates to first two digits after the dot. I use this for Simple Mind Containers' scryglass info. */
	public static String prettifyFloat(float value) {
		// val % 0.01 flickers sometimes
		return String.valueOf(Math.floor((double)value * 100.0) / 100.0);
	}
	/** truncates to first two digits after the dot. */
	public static double prettifyDouble(double value) {
		return Math.floor(value * 100.0) / 100.0;
	}
	/** truncates all components to first 2 digits after the dot. */
	public static class_243 prettifyVec3d(class_243 vec) {
		return new class_243(
			prettifyDouble(vec.field_1352),
			prettifyDouble(vec.field_1351),
			prettifyDouble(vec.field_1350)
		);
	}

	public static boolean matchShape(HexPattern pat1, HexPattern p2) {
		// i think i read somewhere by some guy that if you record how many times
		// a position is drawn over then it's fine
		// he wasn't too sure though, but i pray he's right
		// because nothing else i've done has worked
		return equalsButUnordered(setTopLeftOrigin(pat1.positions()), setTopLeftOrigin(p2.positions()));
	}
	public static List<HexCoord> setTopLeftOrigin(List<HexCoord> pat) {
		HexCoord runningTopLeft = new HexCoord(0, 0);
		for (HexCoord coord : pat) {
			if (coord.getQ() < runningTopLeft.getQ() && coord.getR() <= runningTopLeft.getR()) {
				runningTopLeft = new HexCoord(coord.getQ(), coord.getR());
			} else if (coord.getR() < runningTopLeft.getR()) {
				runningTopLeft = new HexCoord(coord.getQ(), coord.getR());
			}
		}
        LOGGER.info("top left!: " + runningTopLeft.toString());
		// "must be final" my ass
		HexCoord topLeft = new HexCoord(runningTopLeft.getQ(), runningTopLeft.getR());
        return pat.stream().map((coord) -> {
            return new HexCoord(coord.getQ() - topLeft.getQ(), coord.getR() - topLeft.getR());
        }).collect(Collectors.toList());
	}
    /** Checks if two lists are equal, but does not check if their elements are ordered the same way. */
    public static <T extends Object> boolean equalsButUnordered(List<T> list1, List<T> list2) {
        if (list1.size() != list2.size()) { return false; }
        else if (list1.size() == 0) { return true; }
        List<T> l2 = new ArrayList<T>(list2);
        for (T thing : list1) {
            int idx = l2.indexOf(thing);
            if (idx == -1) { return false; }
            l2.remove(idx);
        }
        return true;
    }

	public static <T extends Object> List<T> toList(Collection<T> collection) {
		return collection.stream().collect(Collectors.toList());
	}

	public static boolean closeEnough(float a, float b, float epsilon) {
		return Math.abs(b - a) < epsilon;
	}
	public static boolean closeEnough(double a, double b, double epsilon) {
		return Math.abs(b - a) < epsilon;
	}

    /** returns null if hand isn't MAIN_HAND or OFF_HAND or inaccessible (i'll add more eventually..!!) */
    @Nullable
    public static class_1799 getStackFromHand(CastingEnvironment ctx, int hand) {
        List<HeldItemInfo> stacks = ((GetStacks)ctx).getHeldStacks();
        try { return stacks.get(hand).stack(); }
		catch (IndexOutOfBoundsException e) {
			LOGGER.info("Someone tried to access idx " + hand + " of " + stacks.toString() + ".");
			return null;
		}
    }

	/** returns null if resulting Hand can't be MAIN_HAND or OFF_HAND (MORE WILL COME, THEE SHALL KNOW) */
	@Nullable
	public static class_1268 intToHand(int hand) {
		switch (hand) {
			case 0: return class_1268.field_5808;
			case 1: return class_1268.field_5810;
			default: return null;
		}
	}

	/** Returns stuff like Text.translateable("hands.lapisworks.43") (43rd hand)
	 * if it doesn't know wtf that Hand is */
	public static class_2561 handToString(class_1268 hand) {
		if (hand == class_1268.field_5808) { return MAINHAND; }
		else if (hand == class_1268.field_5810) { return OFFHAND; }
		return class_2561.method_43471("hands.lapisworks." + hand.ordinal());
	}

	/** Will update when the third and fourth hands expansion comes out fr */
	public static List<class_1268> getAllHands() {
		return new ArrayList<>(List.of(class_1268.field_5808, class_1268.field_5810));
	}
}
