package com.luxof.lapisworks.blocks.entities;

import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.blocks.Mind;
import com.luxof.lapisworks.init.ModBlocks;
import com.luxof.lapisworks.mixinsupport.ArtMindInterface;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class MindEntity extends class_2586 {
    public float mindCompletion = 0f;
    // all of this is for you to fw
    public static int maxVillagersForBrainGather = 3;
    public static int gatherRange = 5;
    // magic numbers: fills to 100 by the 4 minute mark
    public static float villagerExhaustionRate = 100f / (4f * 60f * 20f);
    // magic numbers: 20 seconds
    public static int villagerExhaustRegenCD = 20 * 20;
    // magic number: entire minecraft day in ticks
    public static int sleepingVillagerUseAgainCD = 24000;
    // magic numbers: fills to 100 by the 20 minute mark
    public static float mindCompleteRatePerVillager = 100f / (20f * 60f * 20f);

    public MindEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.MIND_ENTITY_TYPE, pos, state);
    }

    public long getMaxMediaGainFromAbsorption() {
        // here for your @Override pleasure
        return MediaConstants.CRYSTAL_UNIT;
    }

    public static int computeFilledState(float filledPercent) {
        // 7.14 is 100 / 14
        // i need to do X/(100/14) to get nums from 0-14
        return (int)Math.max(Math.min(Math.floor((double)filledPercent / 7.14), 14.0), 0.0);
    }

    public static void consumeVillagerMinds(class_1937 world, class_2338 pos, MindEntity blockEntity) {
        class_243 topLeftBack = pos.method_46558().method_1023(gatherRange, gatherRange, gatherRange);
        class_243 bottomRightFront = pos.method_46558().method_1031(gatherRange, gatherRange, gatherRange);
        List<class_1646> villagersNear = new ArrayList<class_1646>(world.method_8390(
            class_1646.class,
            new class_238(topLeftBack, bottomRightFront),
            (villager) -> {
                return ((ArtMindInterface)villager).getUsedMindPercentage() < 100.0f &&
                       ((ArtMindInterface)villager).getDontUseAgainTicks() <= 0;
            }
        ));
        int usedVillagersCount = 0;
        for (int i = 0; i < Math.min(villagersNear.size(), maxVillagersForBrainGather); i++) {
            int idx = world.field_9229.method_43048(villagersNear.size());
            class_1646 villager = villagersNear.get(idx);
            if (villager.method_6113() && usedVillagersCount == 0) {
                blockEntity.mindCompletion += 15.0f;
                blockEntity.mindCompletion = Math.min(100.0f, blockEntity.mindCompletion);
                ((ArtMindInterface)villager).setDontUseAgainTicks(sleepingVillagerUseAgainCD);
                break;
            }
            usedVillagersCount += 1;
            villagersNear.remove(idx);
            // note: villager mined using percentage and mindCompletion can both be >100
            // i'm aware, and this doesn't matter that much
            ((ArtMindInterface)villager).incUsedMindPercentage(villagerExhaustionRate);
            ((ArtMindInterface)villager).setMindBeingUsedTicks(villagerExhaustRegenCD);
            blockEntity.mindCompletion += mindCompleteRatePerVillager;
            blockEntity.mindCompletion = Math.min(100.0f, blockEntity.mindCompletion);
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, class_2586 bE) {
        if (world.field_9236) { return; }
        MindEntity blockEntity = (MindEntity)bE; // do this or function signature doesn't match???
        if (blockEntity.mindCompletion < 100.0f) { consumeVillagerMinds(world, pos, blockEntity); }
        int shouldBeAtState = computeFilledState(blockEntity.mindCompletion);
        if (state.method_11654(Mind.FILLED) != shouldBeAtState) {
            world.method_8501(pos, state.method_11657(Mind.FILLED, shouldBeAtState));
        }
        blockEntity.method_5431();
        if (!world.field_9236) {
            world.method_8413(pos, state, state, class_2248.field_31036);
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("mindCompletion", this.mindCompletion);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.mindCompletion = nbt.method_10583("mindCompletion");
    }

    @Override @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }
}
