package com.luxof.lapisworks.items;

import at.petrak.hexcasting.common.lib.HexSounds;

import static com.luxof.lapisworks.Lapisworks.LOGGER;
import static com.luxof.lapisworks.LapisworksIDs.DIARIES_TOOLTIP_1;
import static com.luxof.lapisworks.LapisworksIDs.DIARIES_TOOLTIP_2;
import static com.luxof.lapisworks.LapisworksIDs.DIARIES_TOOLTIP_3;
import static com.luxof.lapisworks.LapisworksIDs.DIARIES_TOOLTIP_4;
import static com.luxof.lapisworks.LapisworksIDs.GOT_ALL_DIARIES;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import com.luxof.lapisworks.init.Mutables.Mutables;

public class WizardDiaries extends class_1792 {
    public WizardDiaries(class_1793 settings) { super(settings); }
    
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_5783(HexSounds.READ_LORE_FRAGMENT, 1.0F, 1.0F);
        class_1799 handStack = user.method_5998(hand);
        if (!(user instanceof class_3222)) {
            handStack.method_7934(1);
            return class_1271.method_22427(handStack);
        }
        class_3222 suser = (class_3222)user;

        List<class_2960> shuffled = new ArrayList<class_2960>(Mutables.wizardDiariesGainableAdvancements);
        class_161 chosenAdvancement = null;
        Collections.shuffle(shuffled);
        for (int i = 0; i < shuffled.size(); i++) {
            class_2960 advId = shuffled.get(i);
            class_161 adv = suser.method_5682().method_3851().method_12896(advId);
            if (adv == null) {
                LOGGER.warn(advId.toString() + " isn't an advancement that exists right now!");
                continue;
            }
            if (!suser.method_14236().method_12882(adv).method_740()) {
                chosenAdvancement = adv;
                break;
            }
        }
        if (chosenAdvancement == null) {
            suser.method_7353(GOT_ALL_DIARIES, true);
            suser.method_7255(100);
        } else {
            // no clue if this'll work
            suser.method_14236().method_12878(chosenAdvancement, "grant");
        }

        class_174.field_1198.method_8821(suser, handStack);
        suser.method_14248().method_15022(suser, class_3468.field_15372.method_14956(this), 1);
        handStack.method_7934(1);

        return class_1271.method_22427(handStack);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 ctx) {
        tooltip.add(DIARIES_TOOLTIP_1.method_27661().method_27692(
            class_124.field_1064
        ));
        tooltip.add(DIARIES_TOOLTIP_2.method_27661().method_27692(
            class_124.field_1064
        ));
        tooltip.add(DIARIES_TOOLTIP_3.method_27661().method_27692(
            class_124.field_1064
        ));
        tooltip.add(DIARIES_TOOLTIP_4.method_27661().method_27692(
            class_124.field_1064
        ));
    }
}
