package com.luxof.lapisworks.mishaps;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;

import static com.luxof.lapisworks.LapisworksIDs.ALREADY_ENCHANTED;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_2561;

public class MishapAlreadyHasEnchantment extends Mishap {
    private final class_1309 whatEntity;
    private final class_2561 enchantmentName;
    private final int whatEnchant;
    private final int whatLevel;

    public MishapAlreadyHasEnchantment(class_1309 whatEntity, class_2561 enchantmentName, int whatEnchant, int whatLevel) {
        this.whatEntity = whatEntity;
        this.enchantmentName = enchantmentName;
        this.whatEnchant = whatEnchant;
        this.whatLevel = whatLevel;
    }

    @Override
    public FrozenPigment accentColor(CastingEnvironment ctx, Context errorCtx) {
        return switch (this.whatEnchant) {
            case 0 -> dyeColor(class_1767.field_7964); // fireyfists
            case 1 -> dyeColor(class_1767.field_7952); // lightningbending
            case 2 -> dyeColor(class_1767.field_7944); // falldmgres
            case 3 -> dyeColor(class_1767.field_7951); // longbreath
            case 4 -> dyeColor(class_1767.field_7954); // fireresist
            default -> dyeColor(class_1767.field_7963); // any other stuff (e.g. unimpl by another mod)
        };
    }

    @Override
    public void execute(CastingEnvironment env, Context errorCtx, List<Iota> stack) {}

    @Override
    public class_2561 errorMessage(CastingEnvironment ctx, Context errorCtx) {
        return class_2561.method_43469(
            ALREADY_ENCHANTED,
            this.whatEntity.method_5477(),
            this.enchantmentName,
            this.enchantmentName,
            whatLevel
        );
    }
}
