package com.luxof.lapisworks.mixin;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.xplat.IXplatAbstractions;

import com.luxof.lapisworks.VAULT.VAULT;
import com.luxof.lapisworks.interop.hextended.items.AmelOrb;
import com.luxof.lapisworks.mixinsupport.EnchSentInterface;
import com.luxof.lapisworks.mixinsupport.GetVAULT;

import static com.luxof.lapisworks.Lapisworks.LOGGER;
import static com.luxof.lapisworks.Lapisworks.getAllHands;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import com.mojang.authlib.GameProfile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 implements GetVAULT {
    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    private final VAULT vault = VAULT.of((class_3222)(Object)this);
    // yall ever think of a word so long it starts lookin wrong despite being correctly spelled n shit?
    // this phenomena is called "semantic satiation" iirc
    @Override public VAULT grabVAULT() { return this.vault; }

    @Inject(at = @At("HEAD"), method = "readCustomDataFromNbt")
    public void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        try {
            if (nbt.method_10577("LAPISWORKS_EnchSent_exists")) {
                class_243 sentPos = new class_243(
                    nbt.method_10574("LAPISWORKS_EnchSent_posX"),
                    nbt.method_10574("LAPISWORKS_EnchSent_posY"),
                    nbt.method_10574("LAPISWORKS_EnchSent_posZ")
                );
                double sentAmbit = nbt.method_10574("LAPISWORKS_EnchSent_Ambit");
                ((EnchSentInterface)this).setEnchantedSentinel(sentPos, sentAmbit);
            }
        } catch (Exception e) {
            LOGGER.warn("Couldn't load enchanted sentinel!");
            e.printStackTrace();
        }
    }

    @Inject(at = @At("HEAD"), method = "writeCustomDataToNbt")
    public void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        class_243 sentPos = ((EnchSentInterface)this).getEnchantedSentinel();
        Double ambit = ((EnchSentInterface)this).getEnchantedSentinelAmbit();
        nbt.method_10556("LAPISWORKS_EnchSent_exists", sentPos != null);
        class_243 usePos = sentPos != null ? sentPos : new class_243(0.0, 0.0, 0.0);
        double useAmbit = ambit != null ? ambit : 0.0;
        nbt.method_10549("LAPISWORKS_EnchSent_posX", usePos.field_1352);
        nbt.method_10549("LAPISWORKS_EnchSent_posY", usePos.field_1351);
        nbt.method_10549("LAPISWORKS_EnchSent_posZ", usePos.field_1350);
        nbt.method_10549("LAPISWORKS_EnchSent_Ambit", useAmbit);
    }

    public class_243 spawnAt = ((EnchSentInterface)this).getEnchantedSentinel();
    public ParticleSpray particles = null;
    public void spawnEnchSentParticles() {
        class_243 sentinelPosition = ((EnchSentInterface)this).getEnchantedSentinel();
        if ((spawnAt == null && sentinelPosition != null) || spawnAt != sentinelPosition) {
            spawnAt = sentinelPosition;
            if (spawnAt != null) { particles = ParticleSpray.burst(spawnAt, 2, 1); }
        }
        else if (spawnAt == null) { return; }
        particles.sprayParticles(
            (class_3218)this.method_37908(), // is it as simple as this? do I not need the whole chain?
            // damn, it IS as simple as that.
            IXplatAbstractions.INSTANCE.getPigment((class_1657)(Object)this)
        );
    }
    public void spawnOrbParticles() {
        List<class_1268> hands = getAllHands();
        for (class_1268 hand : hands) {
            class_1799 stack = this.method_5998(hand);
            if (!(stack.method_7909() instanceof AmelOrb orb)) continue;
            class_243 placeInAmbit = orb.getPlaceInAmbit(stack);
            ParticleSpray particles = ParticleSpray.burst(placeInAmbit, 3, 2);
            particles.sprayParticles(
                (class_3218)this.method_37908(),
                IXplatAbstractions.INSTANCE.getPigment((class_1657)(Object)this)
            );
        }
    }

    @Inject(at = @At("HEAD"), method = "tick")
    public void tick(CallbackInfo ci) {
        this.spawnEnchSentParticles();
        this.spawnOrbParticles();
    }
}
