package com.luxof.lapisworks.blocks;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.init.ModPOIs;

import com.mojang.datafixers.util.Pair;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class JumpSlate extends BlockCircleComponent implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2738> ATTACH_FACE = class_2741.field_12555;
    public static final double THICKNESS = 1;
    public static final class_265 AABB_FLOOR = class_2248.method_9541(0, 0, 0, 16, THICKNESS, 16);
    public static final class_265 AABB_CEILING = class_2248.method_9541(0, 16 - THICKNESS, 0, 16, 16, 16);
    public static final class_265 AABB_EAST_WALL = class_2248.method_9541(0, 0, 0, THICKNESS, 16, 16);
    public static final class_265 AABB_WEST_WALL = class_2248.method_9541(16 - THICKNESS, 0, 0, 16, 16, 16);
    public static final class_265 AABB_SOUTH_WALL = class_2248.method_9541(0, 0, 0, 16, 16, THICKNESS);
    public static final class_265 AABB_NORTH_WALL = class_2248.method_9541(0, 0, 16 - THICKNESS, 16, 16, 16);
    public JumpSlate() {
        super(class_2251.method_9630(class_2246.field_28896).method_9629(4f, 4f));
        this.method_9590(
            this.field_10647.method_11664()
                .method_11657(ENERGIZED, false)
                .method_11657(FACING, class_2350.field_11043)
                .method_11657(WATERLOGGED, false));
    }

    public int SEARCH_LIMIT = 100;
    // used in CircleExecutionStateMixin.
    @Nullable
    public Pair<class_2350, class_2338> getProbableExitPlace(
        class_2350 enterDir,
        class_2338 herePos,
        class_3218 world
    ) {
        //long start = System.currentTimeMillis();
        class_2338 currPos = new class_2338(herePos);
        Pair<class_2350, class_2338> exit = null;
        //LOGGER.info("Our POI: " + ModPOIs.SLATES_KEY.toString());
        for (int i = 0; i < this.SEARCH_LIMIT; i++) {
            currPos = currPos.method_10081(enterDir.method_10163());
            class_6880<class_4158> poiType = world.method_14178()
                .method_19493().method_19132(currPos).orElseGet(() -> null);
            if (poiType == null || !poiType.method_40225(ModPOIs.SLATES_KEY)) continue;
            //LOGGER.info("Found a " + world.getBlockState(currPos).getBlock().getName() + " after " + i + " iterations.");
            exit = new Pair<class_2350, class_2338>(enterDir, currPos);
            break;
        }
        //LOGGER.info("time taken searching for next slate: " + (System.currentTimeMillis() - start));
        return exit;
    }

    @Override
    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return !state.method_11654(WATERLOGGED);
    }

    @SuppressWarnings("deprecation")
    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    private Pair<Integer, CastingImage> pair(Integer num, CastingImage img) {
        return new Pair<Integer, CastingImage>(num, img);
    }
    private Pair<Integer, CastingImage> getStrength(CastingImage img) {
        List<Iota> stack = new ArrayList<>(img.getStack());
        int strength = 1;

        Pair<Integer, CastingImage> fail = pair(strength, img);
        if (stack.size() == 0) { return fail; }
        int lastIdx = stack.size() - 1; // -1 doesn't work
        Iota topIota = stack.get(lastIdx);
        if (!(topIota instanceof DoubleIota top)) { return fail; }
        // must have if not else if or else ^^^ doesn't exist
        // i'll let you interpret that
        if (!DoubleIota.tolerates(top.getDouble(), Math.round(top.getDouble()))) { return fail; }
        stack.remove(lastIdx);
        CastingImage newImg = img.copy(
            List.copyOf(stack),
            img.getParenCount(),
            img.getParenthesized(),
            img.getEscapeNext(),
            img.getOpsConsumed(),
            img.getUserData()
        );
        return pair((int)top.getDouble(), newImg);
    }

    public long calculateCostForStrength(int strength) {
        return (long)(MediaConstants.DUST_UNIT * 2.5 * strength);
    }
    // for @Override-ing in another block
    public class_2350 reverseDirIfNeeded(class_2350 dir, int strength) {
        return strength < 0 ? dir.method_10153() : dir;
    }

    @Override
    public ControlFlow acceptControlFlow(
        CastingImage imgIn,
        CircleCastEnv env,
        class_2350 enterDir,
        class_2338 pos,
        class_2680 bs,
        class_3218 world
    ) {
        Pair<Integer, CastingImage> strengthResult = getStrength(imgIn);
        int stren = strengthResult.getFirst();
        CastingImage imgNow = strengthResult.getSecond();
        // >0 = not enough media found
        if (stren != 0 && stren != 1 && stren >= -100 && stren <= 100) {
            if (env.extractMedia(calculateCostForStrength(Math.abs(stren)), true) > 0) stren = 1;
            else env.extractMedia(calculateCostForStrength(Math.abs(stren)), false);
        } else stren = 1;

        List<Pair<class_2338, class_2350>> exitDirs = List.of(
            // get opp if strength < 0, 'cause then it should reverse direction
            this.exitPositionFromDirection(pos, enterDir, reverseDirIfNeeded(enterDir, stren), stren)
        );

        return new ControlFlow.Continue(imgNow, exitDirs);
    }

    public Pair<class_2338, class_2350> exitPositionFromDirection(class_2338 pos, class_2350 moveDir, class_2350 endUpMovingDir, int strength) {
        return Pair.of(pos.method_10081(moveDir.method_10163().method_35862(strength)), endUpMovingDir);
    }

    @Override
    public boolean canEnterFromDirection(class_2350 enterDir, class_2338 pos, class_2680 bs, class_3218 world) {
        return enterDir != this.normalDir(pos, bs, world).method_10153();
    }

    @Override
    public EnumSet<class_2350> possibleExitDirections(class_2338 pos, class_2680 bs, class_1937 world) {
        EnumSet<class_2350> dirs = EnumSet.allOf(class_2350.class);
        dirs.remove(this.normalDir(pos, bs, world));
        return dirs;
    }

    public EnumSet<class_2350> exitDirs(class_2338 pos, class_2680 bs, class_1937 world, class_2350 ent) {
        EnumSet<class_2350> dirs = possibleExitDirections(pos, bs, world);
        dirs.remove(ent.method_10153());
        return dirs;
    }

    /*@Override
    public Direction normalDir(BlockPos pos, BlockState bs, World world, int recursionLeft) {
        switch (bs.get(ATTACH_FACE)) {
            case FLOOR: { return Direction.UP; }
            case CEILING: { return Direction.DOWN; }
            case WALL: { return bs.get(FACING); }
            default: return null; // <--- never reached, but silences VSCode
        }
    }*/
    @Override
    public class_2350 normalDir(class_2338 pos, class_2680 bs, class_1937 world, int recursionLeft) {
        // why does the new kind of switch expression work when i'm not the one writing it :sob:
        return switch (bs.method_11654(ATTACH_FACE)) {
            case field_12475 -> class_2350.field_11036;
            case field_12473 -> class_2350.field_11033;
            case field_12471 -> bs.method_11654(FACING);
        };
    }

    @Override
    public float particleHeight(class_2338 pos, class_2680 bs, class_1937 world) {
        return 0.5f - 15f / 16f;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch (pState.method_11654(ATTACH_FACE)) {
            case field_12475 -> AABB_FLOOR;
            case field_12473 -> AABB_CEILING;
            case field_12471 -> switch (pState.method_11654(FACING)) {
                case field_11043 -> AABB_NORTH_WALL;
                case field_11034 -> AABB_EAST_WALL;
                case field_11035 -> AABB_SOUTH_WALL;
                // NORTH; up and down don't happen (but we need branches for them)
                default -> AABB_WEST_WALL;
            };
        };
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FACING, ATTACH_FACE, WATERLOGGED);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 pContext) {
        class_3610 fluidState = pContext.method_8045().method_8316(pContext.method_8037());

        for (class_2350 direction : pContext.method_7718()) {
            class_2680 blockstate;
            if (direction.method_10166() == class_2350.class_2351.field_11052) {
                blockstate = this.method_9564()
                    .method_11657(ATTACH_FACE, direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475)
                    .method_11657(FACING, pContext.method_8042().method_10153());
            } else {
                blockstate = this.method_9564()
                    .method_11657(ATTACH_FACE, class_2738.field_12471)
                    .method_11657(FACING, direction.method_10153());
            }
            blockstate = blockstate.method_11657(WATERLOGGED,
                fluidState.method_15767(class_3486.field_15517) && fluidState.method_15761() == 8);

            if (blockstate.method_26184(pContext.method_8045(), pContext.method_8037())) {
                return blockstate;
            }
        }

        return null;
    }

    // i copy and paste as the BlockSlate.java guides
    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return canAttach(pLevel, pPos, getConnectedDirection(pState).method_10153());
    }

    @SuppressWarnings("deprecation")
    @Override
    public class_2680 method_9559(class_2680 pState, class_2350 pFacing, class_2680 pFacingState, class_1936 pLevel,
        class_2338 pCurrentPos, class_2338 pFacingPos) {
        if (pState.method_11654(WATERLOGGED)) {
            pLevel.method_39281(pCurrentPos, class_3612.field_15910, class_3612.field_15910.method_15789(pLevel));
        }

        return getConnectedDirection(pState).method_10153() == pFacing
            && !pState.method_26184(pLevel, pCurrentPos) ?
            pState.method_26227().method_15759()
            : super.method_9559(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public static boolean canAttach(class_4538 pReader, class_2338 pPos, class_2350 pDirection) {
        class_2338 blockpos = pPos.method_10093(pDirection);
        return pReader.method_8320(blockpos).method_26206(pReader, blockpos, pDirection.method_10153());
    }

    protected static class_2350 getConnectedDirection(class_2680 pState) {
        return switch (pState.method_11654(ATTACH_FACE)) {
            case field_12473 -> class_2350.field_11033;
            case field_12475 -> class_2350.field_11036;
            default -> pState.method_11654(FACING);
        };
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657(FACING, rot.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }
}
