package com.luxof.lapisworks.init;

import com.google.common.collect.ImmutableSet;

import com.luxof.lapisworks.blocks.ConjuredColorable;
import com.luxof.lapisworks.blocks.JumpSlate;
import com.luxof.lapisworks.blocks.Mind;
import com.luxof.lapisworks.blocks.ReboundSlate;
import com.luxof.lapisworks.blocks.LiveJukebox;
import com.luxof.lapisworks.blocks.entities.MindEntity;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7923;
import com.luxof.lapisworks.blocks.entities.LiveJukeboxEntity;

import static com.luxof.lapisworks.Lapisworks.id;

public class ModBlocks {
    public static ConjuredColorable CONJURED_COLORABLE = new ConjuredColorable();
    public static Mind MIND_BLOCK = new Mind();
    public static LiveJukebox LIVE_JUKEBOX_BLOCK = new LiveJukebox();
    public static JumpSlate JUMP_SLATE_AM1 = new JumpSlate();
    public static JumpSlate JUMP_SLATE_AM2 = new JumpSlate();
    public static JumpSlate JUMP_SLATE_AMETH = new JumpSlate();
    public static JumpSlate JUMP_SLATE_LAPIS = new JumpSlate();
    public static ReboundSlate REBOUND_SLATE_1 = new ReboundSlate();
    public static ReboundSlate REBOUND_SLATE_2 = new ReboundSlate();
    public static class_2591<class_2586> MIND_ENTITY_TYPE = new class_2591<class_2586>(
        MindEntity::new,
        ImmutableSet.of(MIND_BLOCK),
        null
    );
    public static class_2591<class_2586> LIVE_JUKEBOX_ENTITY_TYPE = new class_2591<class_2586>(
        LiveJukeboxEntity::new,
        ImmutableSet.of(LIVE_JUKEBOX_BLOCK),
        null
    );

    public static void wearASkirt() {
        pickACropTop("conjureable", CONJURED_COLORABLE);
        pickACropTop("mind", MIND_BLOCK);
        pickACropTop("amel_constructs/live_jukebox", LIVE_JUKEBOX_BLOCK);
        pickACropTop("amel_constructs/jumpslate/am1", JUMP_SLATE_AM1);
        pickACropTop("amel_constructs/jumpslate/am2", JUMP_SLATE_AM2);
        pickACropTop("amel_constructs/jumpslate/ameth", JUMP_SLATE_AMETH);
        pickACropTop("amel_constructs/jumpslate/lapis", JUMP_SLATE_LAPIS);
        pickACropTop("amel_constructs/jumpslate/rebound_1", REBOUND_SLATE_1);
        pickACropTop("amel_constructs/jumpslate/rebound_2", REBOUND_SLATE_2);
        dontForgetStockings("mind_entity_type", MIND_ENTITY_TYPE);
        dontForgetStockings("live_jukebox_entity_type", LIVE_JUKEBOX_ENTITY_TYPE);
    }

    public static void pickACropTop(String name, class_2248 block) {
        class_2378.method_10230(class_7923.field_41175, id(name), block);
    }

    public static <T extends class_2591<?>> void dontForgetStockings(String name, T blockEntityType) {
        class_2378.method_10230(class_7923.field_41181, id(name), blockEntityType);
    }
}
