/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.blocks.entities;

import com.luxof.lapisworks.Lapisworks;
import com.luxof.lapisworks.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class LiveJukeboxEntity
extends class_2586 {
    public List<Integer> notes = new ArrayList<Integer>();
    public int frequency = 0;
    public List<Integer> playingNotes = new ArrayList<Integer>(this.notes);
    public int hasBeenTimeBetweenNotes = 0;

    public LiveJukeboxEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.LIVE_JUKEBOX_ENTITY_TYPE, pos, state);
    }

    public void startPlaying() {
        Lapisworks.LOGGER.info("Bet");
        this.hasBeenTimeBetweenNotes = 0;
        this.playingNotes = new ArrayList<Integer>(this.notes);
        Lapisworks.LOGGER.info("notes: " + this.notes.toString());
        Lapisworks.LOGGER.info("now playing: " + this.playingNotes.toString());
        this.method_5431();
    }

    public static class_3414 getInstrument(class_1937 world, class_2338 pos, LiveJukeboxEntity blockEntity) {
        class_2766 instr1 = world.method_8320(pos.method_10084()).method_51364();
        if (instr1.method_51372()) {
            return (class_3414)instr1.method_11886().comp_349();
        }
        class_2766 instr2 = world.method_8320(pos.method_10074()).method_51364();
        return instr2.method_51372() ? (class_3414)class_3417.field_15114.comp_349() : (class_3414)instr2.method_11886().comp_349();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, class_2586 bE) {
        if (world.field_9236) {
            return;
        }
        LiveJukeboxEntity blockEntity = (LiveJukeboxEntity)bE;
        if (blockEntity.playingNotes.isEmpty()) {
            blockEntity.hasBeenTimeBetweenNotes = 0;
            return;
        }
        Lapisworks.LOGGER.info("We must play notes!");
        double timePeriod = 1.0 / (double)blockEntity.frequency;
        if (!Lapisworks.closeEnough(timePeriod * 20.0, (double)blockEntity.hasBeenTimeBetweenNotes, 0.001)) {
            ++blockEntity.hasBeenTimeBetweenNotes;
            blockEntity.method_5431();
            return;
        }
        double latestNote = blockEntity.playingNotes.remove(0).intValue();
        blockEntity.hasBeenTimeBetweenNotes = 0;
        blockEntity.method_5431();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)class_2398.field_11224, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.2, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, latestNote / 24.0);
        }
        world.method_8396(null, pos, LiveJukeboxEntity.getInstrument(world, pos, blockEntity), class_3419.field_15245, 1.0f, (float)(0.5 * Math.pow(2.0, latestNote / 12.0)));
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10572("jukeboxNotes", this.notes);
        nbt.method_10569("jukeboxFrequency", this.frequency);
        nbt.method_10572("jukeboxPlaying", this.playingNotes);
        nbt.method_10569("jukeboxTimeBetweenNotesATM", this.hasBeenTimeBetweenNotes);
    }

    public void method_11014(class_2487 nbt) {
        int[] playingNotes;
        super.method_11014(nbt);
        int[] notes = nbt.method_10561("jukeboxNotes");
        this.notes = new ArrayList<Integer>();
        for (int note : notes) {
            this.notes.add(note);
        }
        this.frequency = nbt.method_10550("jukeboxFrequency");
        for (int note : playingNotes = nbt.method_10561("jukeboxPlaying")) {
            this.playingNotes.add(note);
        }
        this.hasBeenTimeBetweenNotes = nbt.method_10550("jukeboxTimeBetweenNotesATM");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

