package com.luxof.lapisworks;

import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.common.msgs.MsgClearSpiralPatternsS2C;
import at.petrak.hexcasting.common.msgs.MsgOpenSpellGuiS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;

import com.luxof.lapisworks.mixinsupport.EnchSentInterface;
import com.luxof.lapisworks.mixinsupport.LapisworksInterface;

import static com.luxof.lapisworks.Lapisworks.pickUsingSeed;
import static com.luxof.lapisworks.Lapisworks.pickConfigFlags;
import static com.luxof.lapisworks.Lapisworks.LOGGER;
import static com.luxof.lapisworks.Lapisworks.nullConfigFlags;
import static com.luxof.lapisworks.LapisworksIDs.GEODE_DOWSER_REQUEST;
import static com.luxof.lapisworks.LapisworksIDs.SEND_PWSHAPE_PATS;
import static com.luxof.lapisworks.LapisworksIDs.SEND_SENT;
import static com.luxof.lapisworks.init.ModItems.GEODE_DOWSER;
import static com.luxof.lapisworks.init.ThemConfigFlags.turnChosenIntoNbt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

import kotlin.Pair;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1320;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class LapisworksServer {
    public static void onJoinEnchSentStuff(
        class_3244 handler,
        PacketSender sender,
        MinecraftServer server
    ) {
        class_3222 player = handler.method_32311();
        class_243 sentPos = ((EnchSentInterface)player).getEnchantedSentinel();
        Double sentAmbit = ((EnchSentInterface)player).getEnchantedSentinelAmbit();
        if (sentPos == null) { return; }
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(false);
        buf.method_49068(sentPos.method_46409());
        buf.writeDouble(sentAmbit);
        ServerPlayNetworking.send(player, SEND_SENT, buf);
    }

    public static void onJoinPWShapeStuff(
        class_3244 handler,
        PacketSender sender,
        MinecraftServer server
    ) {
        class_3222 player = handler.method_32311();
        class_2540 patsBuf = PacketByteBufs.create();
        // hell naw i'm not dealing with the two extra args to writeMap() (i dunno wtf those are)
        patsBuf.method_10794(turnChosenIntoNbt());
        ServerPlayNetworking.send(player, SEND_PWSHAPE_PATS, patsBuf);
    }

    public static void juiceUpAttr(class_3222 plr, class_1320 attr) {
        try {
            plr.method_6127().method_26842(attr).method_6192(
                plr.method_26826(attr) + ((LapisworksInterface)plr).getAmountOfAttrJuicedUpByAmel(attr)
            );
        } catch (Exception e) {
            LOGGER.error("We had an error in the juiceUpAttr part of the code. USUALLY this shouldn't happen, but it probably isn't a problem if it does.");
            e.printStackTrace();
        }
    }

    public static void onJoinLoadJuicedAttrs(
        class_3244 handler,
        PacketSender sender,
        MinecraftServer server
    ) {
        // somehow this works to fix the bug.
        // i'm guessing somewhere between PlayerEntity#readNbt() and the player loading into the world,
        // PlayerEntity.attributes is reset to the defaults (but then why doesn't health reset to default??)
        class_3222 player = handler.method_32311();
        juiceUpAttr(player, class_5134.field_23721);
        //juiceUpAttr(player, EntityAttributes.GENERIC_MAX_HEALTH);
        juiceUpAttr(player, class_5134.field_23719);
    }

    public static void handleCastingGridPacket(
        MinecraftServer server,
        class_3222 player,
        class_3244 handler,
        class_2540 buf,
        PacketSender responseSender
    ) {
        boolean clearGrid = buf.readBoolean();
        if (clearGrid) {
            IXplatAbstractions.INSTANCE.clearCastingData(player);
            // i don't know why, it's just in the itemstaff code
            MsgClearSpiralPatternsS2C packet = new MsgClearSpiralPatternsS2C(player.method_5667());
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, packet);
            IXplatAbstractions.INSTANCE.sendPacketTracking(player, packet);
        }

        CastingVM vm = IXplatAbstractions.INSTANCE.getStaffcastVM(player, class_1268.field_5808);
        List<ResolvedPattern> patterns = IXplatAbstractions.INSTANCE.getPatternsSavedInUi(player);
        Pair<List<class_2487>, class_2487> descs = vm.generateDescs();

        IXplatAbstractions.INSTANCE.sendPacketToPlayer(
            player,
            new MsgOpenSpellGuiS2C(
                class_1268.field_5808,
                patterns,
                descs.getFirst(),
                descs.getSecond(),
                0 // it says "todo fix" in the hex casting github 'round here, wonder why
            )
        );
    }

    /** public so anyone can easily fw it */
    public static Map<String, BiConsumer<class_3222, class_2540>> dowseResultTakers = new HashMap<>();

    public static void lockIn() {
        dowseResultTakers.put(GEODE_DOWSER_REQUEST, GEODE_DOWSER::serverHandleDowseResult);

        ServerPlayNetworking.registerGlobalReceiver(
            LapisworksIDs.OPEN_CASTING_GRID,
            (
                MinecraftServer server,
                class_3222 player,
                class_3244 handler,
                class_2540 buf,
                PacketSender responseSender
            ) -> handleCastingGridPacket(server, player, handler, buf, responseSender)
        );
        ServerPlayNetworking.registerGlobalReceiver(
            LapisworksIDs.DOWSE_RESULT,
            (
                server, player, handler, buf, responseSender
            ) -> {
                BiConsumer<class_3222, class_2540> dowseResultTaker = dowseResultTakers.get(buf.method_19772());
                if (dowseResultTaker == null) return;
                dowseResultTaker.accept(player, buf);
            }
        );

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            onJoinEnchSentStuff(handler, sender, server);
            onJoinPWShapeStuff(handler, sender, server);
            onJoinLoadJuicedAttrs(handler, sender, server);
        });
        ServerLifecycleEvents.SERVER_STARTED.register((server) -> {
            pickConfigFlags(pickUsingSeed(server.method_30002().method_8412()));
        });
        ServerLifecycleEvents.SERVER_STOPPING.register((server) -> { nullConfigFlags(); });
    }
}
