package com.luxof.lapisworks.VAULT;


import static com.luxof.lapisworks.Lapisworks.LOGGER;
import static com.luxof.lapisworks.Lapisworks.getAllHands;
import static com.luxof.lapisworks.LapisworksIDs.PLAYER_VAULT;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

/** if you're actually looking at VAULT implementations, you're either cooked or cooking */
public class ServPlayerVAULT extends VAULT {
    private final class_3222 player;
    protected ServPlayerVAULT(class_3222 player) { this.player = player; }
    @Override public class_2960 getKindOfVault() { return PLAYER_VAULT; }


    @Override
    public int fetch(Predicate<class_1792> item, Flags flags) {
        Flags currFlags = null;
        int runningSum = 0;
        currFlags = flags.getKindsOfFlag(Flags.EQ_TRINKETS);
        if (currFlags.canSearch(Flags.EQ_TRINKETS)) {
            Optional<TrinketComponent> trinkCompOpt = TrinketsApi.getTrinketComponent(this.player);
            if (trinkCompOpt.isPresent()) {
                TrinketComponent trinkComp = trinkCompOpt.get();
                for (class_3545<SlotReference, class_1799> pair : trinkComp.getAllEquipped()) {
                    class_1799 stack = pair.method_15441();
                    if (currFlags.canWorkIn(Flags.INVITEM, Flags.EQ_TRINKETS)) {
                        runningSum += this.handleFetchInvItem(stack, item, currFlags);
                    }
                    if (currFlags.canWorkIn(Flags.STACKS, Flags.EQ_TRINKETS)) {
                        runningSum += this.handleFetchStack(stack, item, currFlags);
                    }
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.HANDS);
        if (currFlags.canSearch(Flags.HANDS)) {
            for (class_1268 hand : getAllHands()) {
                class_1799 stack = player.method_5998(hand);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.HANDS)) {
                    runningSum += this.handleFetchInvItem(stack, item, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.HANDS)) {
                    runningSum += this.handleFetchStack(stack, item, currFlags);
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.HOTBAR);
        if (currFlags.canSearch(Flags.HOTBAR)) {
            class_1661 inv = this.player.method_31548();
            for (int i = 0; i < class_1661.method_7368(); i++) {
                class_1799 stack = inv.method_5438(i);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.HOTBAR)) {
                    runningSum += this.handleFetchInvItem(stack, item, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.HOTBAR)) {
                    runningSum += this.handleFetchStack(stack, item, currFlags);
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.INVENTORY);
        if (currFlags.canSearch(Flags.INVENTORY)) {
            class_1661 inv = player.method_31548();
            for (int i = class_1661.method_7368(); i < inv.method_5439(); i++) {
                class_1799 stack = inv.method_5438(i);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.INVENTORY)) {
                    runningSum = this.handleFetchInvItem(stack, item, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.INVENTORY)) {
                    runningSum = this.handleFetchStack(stack, item, currFlags);
                }
            }
        }

        return runningSum;
    }


    @SuppressWarnings("null")
    @Override
    public int drain(Predicate<class_1792> item, int amount, Flags flags) {
        Flags currFlags = null;
        int left = amount;
        currFlags = flags.getKindsOfFlag(Flags.EQ_TRINKETS);
        if (currFlags.canSearch(Flags.EQ_TRINKETS)) {
            Optional<TrinketComponent> trinkCompOpt = TrinketsApi.getTrinketComponent(this.player);
            if (trinkCompOpt.isPresent()) {
                TrinketComponent trinkComp = trinkCompOpt.get();
                for (class_3545<SlotReference, class_1799> pair : trinkComp.getAllEquipped()) {
                    class_1799 stack = pair.method_15441();
                    if (currFlags.canWorkIn(Flags.INVITEM, Flags.EQ_TRINKETS)) {
                        left = this.handleDrainInvItem(stack, item, left, currFlags);
                    }
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT DRAINING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.HANDS);
        if (currFlags.canSearch(Flags.HANDS)) {
            for (class_1268 currHand : getAllHands()) {
                class_1799 stack = player.method_5998(currHand);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.HANDS)) {
                    left = this.handleDrainInvItem(stack, item, left, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.HANDS)) {
                    left = this.handleDrainStack(stack, item, left, currHand, player::method_6122);
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT DRAINING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.HOTBAR);
        if (currFlags.canSearch(Flags.HOTBAR)) {
            class_1661 inv = player.method_31548();
            for (int i = 0; i < class_1661.method_7368(); i++) {
                class_1799 stack = inv.method_5438(i);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.HOTBAR)) {
                    left = this.handleDrainInvItem(stack, item, left, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.HOTBAR)) {
                    left = this.handleDrainStack(stack, item, left, i, inv::method_5447);
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT DRAINING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.INVENTORY);
        if (currFlags.canSearch(Flags.INVENTORY)) {
            class_1661 inv = player.method_31548();
            for (int i = class_1661.method_7368(); i < inv.method_5439(); i++) {
                class_1799 stack = inv.method_5438(i);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.INVENTORY)) {
                    left = this.handleDrainInvItem(stack, item, amount, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.INVENTORY)) {
                    left = this.handleDrainStack(stack, item, amount, i, inv::method_5447);
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT DRAINING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        return left;
    }


    @SuppressWarnings("null")
    @Override
    public int give(Predicate<class_1792> item, int amount, Flags flags) {
        Flags currFlags = null;
        int left = amount;
        currFlags = flags.getKindsOfFlag(Flags.EQ_TRINKETS);
        if (currFlags.canSearch(Flags.EQ_TRINKETS)) {
            Optional<TrinketComponent> trinkCompOpt = TrinketsApi.getTrinketComponent(this.player);
            if (trinkCompOpt.isPresent()) {
                TrinketComponent trinkComp = trinkCompOpt.get();
                for (class_3545<SlotReference, class_1799> pair : trinkComp.getAllEquipped()) {
                    class_1799 stack = pair.method_15441();
                    if (currFlags.canWorkIn(Flags.INVITEM, Flags.EQ_TRINKETS)) {
                        left = this.handleGiveInvItem(stack, item, left, currFlags);
                    }
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT GIVING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.HANDS);
        if (currFlags.canSearch(Flags.HANDS)) {
            for (class_1268 hand : getAllHands()) {
                class_1799 stack = player.method_5998(hand);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.HANDS)) {
                    left = this.handleGiveInvItem(stack, item, left, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.HANDS)) {
                    left = this.handleGiveStack(stack, item, left, hand, player::method_6122);
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT GIVING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.HOTBAR);
        if (currFlags.canSearch(Flags.HOTBAR)) {
            class_1661 inv = player.method_31548();
            for (int i = 0; i < class_1661.method_7368(); i++) {
                class_1799 stack = inv.method_5438(i);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.HOTBAR)) {
                    left = this.handleGiveInvItem(stack, item, left, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.HOTBAR)) {
                    left = this.handleGiveStack(stack, item, left, i, inv::method_5447);
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT GIVING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        currFlags = flags.getKindsOfFlag(Flags.INVENTORY);
        if (currFlags.canSearch(Flags.INVENTORY)) {
            class_1661 inv = player.method_31548();
            for (int i = class_1661.method_7368(); i < inv.method_5439(); i++) {
                class_1799 stack = inv.method_5438(i);
                if (currFlags.canWorkIn(Flags.INVITEM, Flags.INVENTORY)) {
                    left = this.handleGiveInvItem(stack, item, amount, currFlags);
                }
                if (currFlags.canWorkIn(Flags.STACKS, Flags.INVENTORY)) {
                    left = this.handleGiveStack(stack, item, amount, i, inv::method_5447);
                }
                if (left == 0) return 0;
                else if (left < 0) {
                    LOGGER.error("CRITICAL ERROR: VAULT GIVING MADE \"left\" < 0!!");
                    return 0;
                }
            }
        }

        return left;
    }
}
