package com.luxof.lapisworks.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.VAULT.VAULT;
import com.luxof.lapisworks.blocks.entities.MindEntity;
import com.luxof.lapisworks.init.ModBlocks;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.init.Mutables.SMindInfusion;
import com.luxof.lapisworks.mixinsupport.GetVAULT;

import static com.luxof.lapisworks.LapisworksIDs.FULL_SIMPLE_MIND;
import static com.luxof.lapisworks.LapisworksIDs.INFUSEABLE_WITH_SMIND;
import static com.luxof.lapisworks.LapisworksIDs.MIND_BLOCK;

import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FlayArtMind implements SpellAction {
    public int getArgc() {
        return 2;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        class_2338 flayIntoPos = OperatorUtils.getBlockPos(args, 0, getArgc());
        VAULT vault = ((GetVAULT)ctx).grabVAULT();
        Map<class_2960, SMindInfusion> recipes = Mutables.testSMindInfusionFilters(
            flayIntoPos,
            ctx,
            args,
            vault
        );
        if (recipes.isEmpty()) {
            MishapThrowerJava.throwMishap(new MishapBadBlock(
                flayIntoPos,
                INFUSEABLE_WITH_SMIND
            ));
        }
        SMindInfusion recipe = recipes.values().iterator().next();
        recipe.mishapIfNeeded();

        // be funny. come on. try it.
        class_2338 mindPos = OperatorUtils.getBlockPos(args, 1, getArgc());
        MindEntity blockEntity = MishapThrowerJava.throwIfEmpty(
            ctx.getWorld().method_35230(mindPos, ModBlocks.MIND_ENTITY_TYPE),
            new MishapBadBlock(mindPos, MIND_BLOCK)
        );
        if (blockEntity.mindCompletion < 100f) {
            MishapThrowerJava.throwMishap(new MishapBadBlock(
                mindPos,
                FULL_SIMPLE_MIND
            ));
        }
        blockEntity.mindCompletion = 0F;

        return new SpellAction.Result(
            new Spell(flayIntoPos, recipe),
            MediaConstants.CRYSTAL_UNIT,
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 2, 15)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_2338 flayIntoPos;
        public final SMindInfusion flayer;

        public Spell(class_2338 flayIntoPos, SMindInfusion flayer) {
            this.flayIntoPos = flayIntoPos;
            this.flayer = flayer;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            this.flayer.accept();
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }

    @Nullable
    public static class_3222 getPlayerOrNull(CastingEnvironment ctx) {
        return ctx.getCastingEntity() != null ? (class_3222)ctx.getCastingEntity() : null;
    }
}
