package com.luxof.lapisworks.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.VAULT.Flags;
import com.luxof.lapisworks.VAULT.VAULT;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.mishaps.MishapNotEnoughItems;
import com.luxof.lapisworks.mixinsupport.GetVAULT;
import com.luxof.lapisworks.mixinsupport.LapisworksInterface;

import static com.luxof.lapisworks.LapisworksIDs.AMEL;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

// "too late" (lazy) to make this use EntityAttributeModifiers instead
public class MoarAttr implements SpellAction {
    // i always keep my shit public in case someone needs to do something cursed
    public class_1320 modifyAttribute;
    public double limitModifier;
    public double limitOffset; // "only give mobs +60 +2xbase hp at max!"
    public double attrCompensateMult; // base plr speed is 0.1? set this to 10 or smth.
    public int expendedAmelModifier;
    public boolean playerOnly;

    public MoarAttr(
        class_1320 modifyAttribute,
        double limitModifier,
        double limitOffset,
        double attrCompensateMult,
        int expendedAmelModifier,
        boolean playerOnly
    ) {
        this.modifyAttribute = modifyAttribute;
        this.limitModifier = limitModifier;
        this.limitOffset = limitOffset;
        this.attrCompensateMult = attrCompensateMult;
        this.expendedAmelModifier = expendedAmelModifier;
        this.playerOnly = playerOnly;
    }

    public int getArgc() {
        return 2;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        class_1309 entity;
        if (!playerOnly) { entity = OperatorUtils.getLivingEntityButNotArmorStand(args, 0, getArgc()); }
        else { entity = OperatorUtils.getPlayer(args, 0, getArgc()); }
        double count = OperatorUtils.getPositiveDouble(args, 1, getArgc());

        VAULT vault = ((GetVAULT)ctx).grabVAULT();
        int availableAmel = vault.fetch(Mutables::isAmel, Flags.PRESET_Stacks_InvItem_UpToHotbar);

        double currentCombinedVal = entity.method_6127()
            .method_26842(this.modifyAttribute)
            .method_6201();
        double currentJuicedUpVal = ((LapisworksInterface)entity).getAmountOfAttrJuicedUpByAmel(
            this.modifyAttribute
        );
        double defaultVal = currentCombinedVal - currentJuicedUpVal;
        double defaultValCompensated = defaultVal * this.attrCompensateMult;
        double baseLimit = defaultValCompensated * this.limitModifier + this.limitOffset;
        double currentLimit = baseLimit - currentCombinedVal;

        double addToVal = Math.min(
            Math.min(defaultValCompensated + count, baseLimit) - defaultValCompensated,
            currentLimit
        );
        int expendedAmel = (int)Math.ceil(addToVal * this.expendedAmelModifier);

        if (availableAmel < expendedAmel) {
            MishapThrowerJava.throwMishap(new MishapNotEnoughItems(
                AMEL,
                availableAmel,
                expendedAmel
            ));
        }

        // 0 in case some genius actually exploited the bug from 1.5.5.5,
        // we don't want shit softlocking til death
        if (expendedAmel < 0) {
            if (entity instanceof class_3222) {
                ((class_3222)entity).method_7353(class_2561.method_43471("notif.lapisworks.you_used_the_enchant_bug"), true);
            }
            expendedAmel = 0;
            addToVal = 0;
            entity.method_6127().method_26842(this.modifyAttribute).method_6192(defaultVal);
        }

        return new SpellAction.Result(
            // caster is kinda being operated on but that's not the main effect so 2nd prio
            new Spell(
                entity, vault, this.modifyAttribute,
                expendedAmel, addToVal / this.attrCompensateMult),
            Math.max(MediaConstants.SHARD_UNIT * expendedAmel, 0),
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 2, 25)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_1309 entity;
        public final VAULT vault;
        public final class_1320 attr;
        public final int expendedAmel;
        public final double addVal;

        public Spell(
            class_1309 entity,
            VAULT vault,
            class_1320 attr,
            int expendedAmel,
            double addVal
        ) {
            this.entity = entity;
            this.vault = vault;
            this.expendedAmel = expendedAmel;
            this.addVal = addVal;
            this.attr = attr;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            vault.drain(Mutables::isAmel, expendedAmel, Flags.PRESET_Stacks_InvItem_UpToHotbar);
            class_1324 AttrInst = this.entity.method_6127().method_26842(this.attr);
            AttrInst.method_6192(AttrInst.method_6201() + this.addVal);
            double juicedUpAttr = ((LapisworksInterface)this.entity).getAmountOfAttrJuicedUpByAmel(this.attr);
            ((LapisworksInterface)this.entity).setAmountOfAttrJuicedUpByAmel(
                this.attr,
                juicedUpAttr + this.addVal
            );
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
