package com.luxof.lapisworks.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.google.common.collect.ImmutableMultimap;

import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.VAULT.Flags;
import com.luxof.lapisworks.VAULT.VAULT;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.mishaps.MishapNotEnoughItems;
import com.luxof.lapisworks.mixinsupport.GetVAULT;

import static com.luxof.lapisworks.LapisworksIDs.AMEL;
import static com.luxof.lapisworks.LapisworksIDs.ATK_RANGE_ENHANCEMENT_UUID;
import static com.luxof.lapisworks.LapisworksIDs.REACH_ENHANCEMENT_UUID;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1322.class_1323;
import net.minecraft.class_2487;
import net.minecraft.class_5131;

public class MoarReachYouBitch implements SpellAction {
    public static final int amelCost = 16;
    public static final int amelCostMultiplier = 4;
    public static final int reachIncrease = 3;
    public static final int attackReachIncrease = 1;
    public static final class_1322 REACH_MODIFIER = new class_1322(
        REACH_ENHANCEMENT_UUID,
        "Lapisworks reach enhancement",
        reachIncrease,
        class_1323.field_6328
    );
    public static final class_1322 ATTACK_REACH_MODIFIER = new class_1322(
        ATK_RANGE_ENHANCEMENT_UUID,
        "Lapisworks attack reach ehancement",
        attackReachIncrease,
        class_1323.field_6328
    );
    @SuppressWarnings("null")
    private final ImmutableMultimap<class_1320, class_1322> modifiers = ImmutableMultimap.of(
        ReachEntityAttributes.REACH, REACH_MODIFIER,
        ReachEntityAttributes.ATTACK_RANGE, ATTACK_REACH_MODIFIER
    );

    public int getArgc() {
        return 1;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        class_1309 entity = OperatorUtils.getPlayer(args, 0, getArgc());

        boolean expendShit = !entity.method_6127().method_27305(
            ReachEntityAttributes.REACH,
            REACH_ENHANCEMENT_UUID
        );

        VAULT vault = ((GetVAULT)ctx).grabVAULT();
        int availableAmel = vault.fetch(Mutables::isAmel, Flags.PRESET_Stacks_InvItem_UpToHotbar);
        if (availableAmel < (expendShit ? amelCost : 0)) {
            MishapThrowerJava.throwMishap(new MishapNotEnoughItems(
                AMEL,
                availableAmel,
                amelCost
            ));
        }

        return new SpellAction.Result(
            new Spell(entity, vault),
            Math.max(MediaConstants.SHARD_UNIT * (expendShit ? 4 : 0), 0),
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 2, 25)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_1309 entity;
        public final VAULT vault;

        public Spell(
            class_1309 entity,
            VAULT vault
        ) {
            this.entity = entity;
            this.vault = vault;
        }

		@SuppressWarnings("null")
        @Override
		public void cast(CastingEnvironment ctx) {
            class_5131 attrs = entity.method_6127();
            if (attrs.method_27305(ReachEntityAttributes.REACH, REACH_ENHANCEMENT_UUID)) return;

            vault.drain(
                Mutables::isAmel,
                amelCost,
                Flags.PRESET_Stacks_InvItem_UpToHotbar
            );
            entity.method_6127().method_26854(modifiers);
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
