package com.luxof.lapisworks.actions;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment.HeldItemInfo;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.inv.HandsInv;
import com.luxof.lapisworks.mixinsupport.GetStacks;
import com.luxof.lapisworks.recipes.MoldRec;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class SwapAmel implements SpellAction {
    public int getArgc() {
        return 0;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        MoldRec recipe = ctx.getWorld().method_8433().method_8132(
            MoldRec.Type.INSTANCE,
            new HandsInv(((GetStacks)ctx).getHeldItemStacks()),
            ctx.getWorld()
        ).orElseGet(() -> {
            MishapThrowerJava.throwMishap(new MishapBadOffhandItem(
                class_1799.field_8037.method_7972(),
                class_2561.method_43471("mishaps.lapisworks.descs.moldable")
            ));
            return null;
        });
        class_1792 swapWith = recipe.getOutput();
        HeldItemInfo inputItems = ctx.getHeldItemToOperateOn(stack -> recipe.getInput().method_8093(stack));
        int count = inputItems.stack().method_7947();
        class_1268 hand = inputItems.hand();

        return new SpellAction.Result(
            new Spell(swapWith, count, hand),
            0,
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 1, 10 + count)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_1792 item;
        public final int count;
        public final class_1268 hand;

        public Spell(class_1792 item, int count, class_1268 hand) {
            this.item = item;
            this.count = count;
            this.hand = hand;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            ctx.replaceItem(
                stack -> true,
                new class_1799(this.item, this.count),
                this.hand
            );
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
