package com.luxof.lapisworks.actions.interact;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.EulerPathFinder;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadCaster;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.misc.MediaConstants;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.items.storage.ItemScroll;
import at.petrak.hexcasting.xplat.IXplatAbstractions;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.blocks.Mind;
import com.luxof.lapisworks.blocks.entities.MindEntity;
import com.luxof.lapisworks.init.ModBlocks;

import static com.luxof.lapisworks.Lapisworks.LOGGER;
import static com.luxof.lapisworks.Lapisworks.matchShape;
import static com.luxof.lapisworks.LapisworksIDs.FULL_SIMPLE_MIND;
import static com.luxof.lapisworks.LapisworksIDs.GREAT_SCROLL;
import static com.luxof.lapisworks.LapisworksIDs.MIND_BLOCK;
import static com.luxof.lapisworks.LapisworksIDs.PAT_SCROLL;
import static com.luxof.lapisworks.LapisworksIDs.SCROLL;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

/** my excuses:
 *  - HexResearch is still stuck at 1.19.2
 *  - I think the artificial mind makes more sense in the context of Lapisworks' "materials
 *      interact with media" shtick (recipe-wise and lore-wise too)
 *  - artificial minds can't thought sieve in HexResearch and can only be flayed to make budding amethyst
 * but ultimately, those are just excuses.
 * sorry lmao
 */
public class HexResearchYoink implements SpellAction {
    @Nullable
    public HexPattern getPerWorldPatternByShape(HexPattern pattern, CastingEnvironment ctx) {
        class_2378<ActionRegistryEntry> registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (class_5321<ActionRegistryEntry> key : registry.method_42021()) {
            ActionRegistryEntry action = registry.method_29107(key);
            if (HexUtils.isOfTag(registry, key, HexTags.Actions.PER_WORLD_PATTERN)) {
                HexPattern scrungled = EulerPathFinder.findAltDrawing(
                    action.prototype(),
                    ctx.getWorld().method_8412()
                );
                LOGGER.info("Scrungled name: " + key.method_29177().toString());
                if (scrungled.anglesSignature().equals(pattern.anglesSignature())) { return scrungled; }
                else if (matchShape(scrungled, pattern)) { return scrungled; }
            }
        };
        return null;
    }
    
    public int getArgc() {
        return 1;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        Optional<class_1309> casterOp = Optional.of(ctx.getCastingEntity());
        if (casterOp.isEmpty()) { MishapThrowerJava.throwMishap(new MishapBadCaster()); }
        class_1309 caster = casterOp.get();


        class_2338 mindPos = OperatorUtils.getBlockPos(args, 0, getArgc());
        try { ctx.assertPosInRange(mindPos); }
        catch (Mishap mishap) { MishapThrowerJava.throwMishap(mishap); }
        MishapBadBlock needMind = new MishapBadBlock(mindPos, MIND_BLOCK);
        if (!(ctx.getWorld().method_8320(mindPos).method_26204() instanceof Mind)) {
            MishapThrowerJava.throwMishap(needMind);
        }

        MindEntity blockEntity = MishapThrowerJava.throwIfEmpty(
            ctx.getWorld().method_35230(mindPos, ModBlocks.MIND_ENTITY_TYPE),
            needMind
        );
        if (blockEntity.mindCompletion < 100f) {
            MishapThrowerJava.throwMishap(new MishapBadBlock(mindPos, FULL_SIMPLE_MIND));
        }


        class_1799 offHandItems = caster.method_6079();
        if (!(offHandItems.method_7909() instanceof ItemScroll)) {
            MishapThrowerJava.throwMishap(new MishapBadOffhandItem(
                offHandItems,
                SCROLL
            ));
        }
        ItemScroll scroll = (ItemScroll)offHandItems.method_7909();


        Iota iota = scroll.readIota(offHandItems, ctx.getWorld());
        // imagine someone funny says "what if scroll stores number"
        if (!(iota instanceof PatternIota)) {
            MishapThrowerJava.throwMishap(new MishapBadOffhandItem(
                offHandItems,
                PAT_SCROLL
            ));
        }


        // maybe i shouldn't calculate the pattern regardless of if it's going to even write it?
        HexPattern realPattern = getPerWorldPatternByShape(((PatternIota)iota).getPattern(), ctx);
        if (realPattern == null) {
            MishapThrowerJava.throwMishap(new MishapBadOffhandItem(
                offHandItems,
                GREAT_SCROLL
            ));
        }

        return new SpellAction.Result(
            new Spell(caster, blockEntity, realPattern, scroll),
            MediaConstants.CRYSTAL_UNIT,
            List.of(ParticleSpray.burst(caster.method_19538(), 2, 15)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_1309 caster;
        public final MindEntity blockEntity;
        public final HexPattern pattern;
        public final ItemScroll scroll;

        public Spell(class_1309 caster, MindEntity blockEntity, HexPattern pattern, ItemScroll scroll) {
            this.caster = caster;
            this.blockEntity = blockEntity;
            this.pattern = pattern;
            this.scroll = scroll;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            this.blockEntity.mindCompletion -= 50.0f;
            this.blockEntity.method_5431();
            if (ctx.getWorld().field_9229.method_43048(4) > 2) { return; } // 3/5 chance (number is 0-4 inclusive)
            this.scroll.writeDatum(caster.method_6079(), new PatternIota(this.pattern));
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
