package com.luxof.lapisworks.actions.interact;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.SpellActionNoCarpalTunnel;
import com.luxof.lapisworks.VAULT.Flags;
import com.luxof.lapisworks.blocks.stuff.LinkableMediaBlock;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.mixinsupport.GetVAULT;

import static com.luxof.lapisworks.Lapisworks.getDistance;
import static com.luxof.lapisworks.MishapThrowerJava.assertAmelAmount;
import static com.luxof.lapisworks.MishapThrowerJava.assertInRange;
import static com.luxof.lapisworks.MishapThrowerJava.assertIsntLinked;
import static com.luxof.lapisworks.MishapThrowerJava.assertLinkableThere;
import static com.luxof.lapisworks.MishapThrowerJava.assertNotTooManyLinks;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

// :face_holding_back_tears:
public class LinkCondensers extends SpellActionNoCarpalTunnel {
    public int argc = 2;

    @Override
    public Result execute(hexStack stack, CastingEnvironment ctx) {
        class_2338 pos1 = stack.getBlockPos(0);
        class_2338 pos2 = stack.getBlockPos(1);

        assertInRange(ctx, pos1);
        assertInRange(ctx, pos2);

        LinkableMediaBlock linkable1 = assertLinkableThere(pos1, ctx);
        LinkableMediaBlock linkable2 = assertLinkableThere(pos2, ctx);

        assertIsntLinked(linkable1, pos2);
        assertNotTooManyLinks(linkable1, linkable2, pos1, pos2);

        // "costs 1 amel per 32 blocks of distance, with a minimum of 1."
        int amelCost = (int)Math.max(1, Math.floor(getDistance(pos1, pos2) / 32.0));
        assertAmelAmount(ctx, amelCost);

        return new Result(
            new Spell(pos1, pos2, amelCost),
            MediaConstants.CRYSTAL_UNIT * 3,
            List.of(
                ParticleSpray.burst(pos1.method_46558(), 5, 30),
                ParticleSpray.burst(pos2.method_46558(), 5, 30)
            ),
            1
        );
    }
    
    public class Spell implements RenderedSpellNoCarpalTunnel {
        public final class_2338 pos1;
        public final class_2338 pos2;
        public final int amel;
        public Spell(class_2338 pos1, class_2338 pos2, int amel) {
            this.pos1 = pos1;
            this.pos2 = pos2;
            this.amel = amel;
        }

        @Override
        public void cast(CastingEnvironment ctx) {
            ((GetVAULT)ctx).grabVAULT().drain(
                Mutables::isAmel,
                amel,
                Flags.PRESET_Stacks_InvItem_UpToHotbar
            );
            class_3218 world = ctx.getWorld();
            ((LinkableMediaBlock)world.method_8321(pos1)).addLink(pos2);
            ((LinkableMediaBlock)world.method_8321(pos2)).addLink(pos1);
        }
    }
}
