package com.luxof.lapisworks.actions.interact;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment.HeldItemInfo;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.xplat.IXplatAbstractions;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.blocks.Mind;
import com.luxof.lapisworks.blocks.entities.MindEntity;
import com.luxof.lapisworks.init.ModBlocks;

import static com.luxof.lapisworks.LapisworksIDs.MIND_BLOCK;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;

/** you could make like 10 / (6.666.. * 60) = 0.025 dust per second per mind from this
 * so hexal wisp eating isn't overran */
public class MindLiquefaction implements SpellAction {
    private static boolean isMediaHolder(class_1799 stack) {
        if (stack == null || stack.method_7960()) { return false; }
        ADMediaHolder mediaHolder = IXplatAbstractions.INSTANCE.findMediaHolder(stack);
        return mediaHolder == null || !mediaHolder.canRecharge();
    }

    public int getArgc() {
        return 1;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        class_2338 mindPos = OperatorUtils.getBlockPos(args, 0, getArgc());
        try { ctx.assertPosInRange(mindPos); }
        catch (Mishap mishap) { MishapThrowerJava.throwMishap(mishap); }
        MishapBadBlock needMind = new MishapBadBlock(mindPos, MIND_BLOCK);
        if (!(ctx.getWorld().method_8320(mindPos).method_26204() instanceof Mind)) {
            MishapThrowerJava.throwMishap(needMind);
        }

        MindEntity blockEntity = MishapThrowerJava.throwIfEmpty(
            ctx.getWorld().method_35230(mindPos, ModBlocks.MIND_ENTITY_TYPE),
            needMind
        );

        Mishap needRechargeable = MishapBadOffhandItem.of(class_1799.field_8037.method_7972(), "rechargeable");
        HeldItemInfo heldStackInfo = ctx.getHeldItemToOperateOn(MindLiquefaction::isMediaHolder);
        if (heldStackInfo == null) {
            MishapThrowerJava.throwMishap(needRechargeable);
            return null; // VSCode likes complaining about null
        }


        return new SpellAction.Result(
            new Spell(blockEntity, heldStackInfo.component1()),
            0L,
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 2, 15)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final MindEntity blockEntity;
        public final class_1799 heldStack;

        public Spell(MindEntity blockEntity, class_1799 heldStack) {
            this.blockEntity = blockEntity;
            this.heldStack = heldStack;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            ADMediaHolder media = IXplatAbstractions.INSTANCE.findMediaHolder(this.heldStack);
            media.insertMedia(
                Math.min(
                    media.insertMedia(-1, true),
                    this.blockEntity.getMaxMediaGainFromAbsorption() * ((long)blockEntity.mindCompletion / 100L)
                ),
                false
            );
            this.blockEntity.mindCompletion = 0;
            this.blockEntity.method_5431();
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
