package com.luxof.lapisworks.actions.interact;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.blocks.entities.SimpleImpetusEntity;
import com.luxof.lapisworks.init.ModBlocks;

import static com.luxof.lapisworks.LapisworksIDs.SIMP_IMP_BLOCK;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class TeachSImp implements SpellAction {
    public int getArgc() {
        return 2;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        class_2338 pos = OperatorUtils.getBlockPos(args, 0, getArgc());
        SimpleImpetusEntity blockEntity = MishapThrowerJava.throwIfEmpty(
            ctx.getWorld().method_35230(pos, ModBlocks.SIMPLE_IMPETUS_ENTITY_TYPE),
            new MishapBadBlock(pos, SIMP_IMP_BLOCK)
        );

        return new SpellAction.Result(
            new Spell(blockEntity, OperatorUtils.getPattern(args, 1, getArgc()).anglesSignature()),
            MediaConstants.DUST_UNIT * 2,
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 2, 15)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final SimpleImpetusEntity blockEntity;
        public final String angSig;

        public Spell(SimpleImpetusEntity blockEntity, String angSig) {
            this.blockEntity = blockEntity;
            this.angSig = angSig;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            this.blockEntity.tune(angSig, true);
            this.blockEntity.method_5431();
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }

    @Nullable
    public static class_3222 getPlayerOrNull(CastingEnvironment ctx) {
        return ctx.getCastingEntity() != null ? (class_3222)ctx.getCastingEntity() : null;
    }
}
