package com.luxof.lapisworks.actions.interact;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.SpellActionNoCarpalTunnel;
import com.luxof.lapisworks.blocks.stuff.LinkableMediaBlock;

import static com.luxof.lapisworks.MishapThrowerJava.assertInRange;
import static com.luxof.lapisworks.MishapThrowerJava.assertIsLinked;
import static com.luxof.lapisworks.MishapThrowerJava.assertLinkableThere;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class UnlinkCondensers extends SpellActionNoCarpalTunnel {
    public int argc = 2;

    @Override
    public Result execute(hexStack stack, CastingEnvironment ctx) {
        class_2338 pos1 = stack.getBlockPos(0);
        class_2338 pos2 = stack.getBlockPos(1);

        assertInRange(ctx, pos1);
        assertInRange(ctx, pos2);

        LinkableMediaBlock linkable1 = assertLinkableThere(pos1, ctx);
        assertLinkableThere(pos2, ctx);

        assertIsLinked(linkable1, pos2);

        return new Result(
            new Spell(pos1, pos2),
            MediaConstants.CRYSTAL_UNIT * 3,
            List.of(
                ParticleSpray.burst(pos1.method_46558(), 5, 30),
                ParticleSpray.burst(pos2.method_46558(), 5, 30)
            ),
            1
        );
    }
    
    public class Spell implements RenderedSpellNoCarpalTunnel {
        public final class_2338 pos1;
        public final class_2338 pos2;
        public Spell(class_2338 pos1, class_2338 pos2) {
            this.pos1 = pos1;
            this.pos2 = pos2;
        }

        @Override
        public void cast(CastingEnvironment ctx) {
            class_3218 world = ctx.getWorld();
            ((LinkableMediaBlock)world.method_8321(pos1)).removeLink(pos2);
            ((LinkableMediaBlock)world.method_8321(pos2)).removeLink(pos1);
        }
    }
}
