package com.luxof.lapisworks.actions.interact;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.misc.MediaConstants;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.lib.HexItems;

import com.google.common.collect.ImmutableSet;

import static com.luxof.lapisworks.Lapisworks.interactWithLinkableMediaBlocks;
import static com.luxof.lapisworks.MishapThrowerJava.assertInRange;
import static com.luxof.lapisworks.MishapThrowerJava.assertLinkableThere;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;

public class Withdraw implements SpellAction {
    public int getArgc() {
        return 2;
    }

    @Override
    public Result execute(List<? extends Iota> hexStack, CastingEnvironment ctx) {
        class_2338 pos = OperatorUtils.getBlockPos(hexStack, 0, getArgc());
        long amount = OperatorUtils.getPositiveInt(hexStack, 1, getArgc()) * MediaConstants.DUST_UNIT;

        assertInRange(ctx, pos);
        assertLinkableThere(pos, ctx);

        class_1799 phialStack = ctx.getHeldItemToOperateOn(stack -> {
            return stack.method_31574(HexItems.BATTERY);
        }).stack();

        return new SpellAction.Result(
            new Spell(pos, phialStack, amount),
            (long)(amount * 0.1),
            List.of(
                ParticleSpray.cloud(ctx.mishapSprayPos(), 3, 20),
                ParticleSpray.cloud(pos.method_46558(), 3, 20)
            ),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_2338 pos;
        public final class_1799 phialStack;
        public final long amount;

        public Spell(class_2338 pos, class_1799 phialStack, long amount) {
            this.pos = pos;
            this.phialStack = phialStack;
            this.amount = amount;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            long used = ((ItemMediaBattery)phialStack.method_7909()).insertMedia(
                phialStack, amount, true
            );
            long withdrawing = interactWithLinkableMediaBlocks(
                ctx.getWorld(),
                ImmutableSet.of(pos),
                used,
                false
            );
            ((ItemMediaBattery)phialStack.method_7909()).insertMedia(
                phialStack,
                withdrawing,
                false
            );
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
