package com.luxof.lapisworks.actions.misc;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.misc.MediaConstants;
import at.petrak.hexcasting.common.items.pigment.ItemDyePigment;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.init.ModBlocks;

import static com.luxof.lapisworks.blocks.ConjuredColorable.COLOR;
import static com.luxof.lapisworks.blocks.ConjuredColorable.PIGMENT;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2968;

public class ConjureColor implements SpellAction {

    public int getArgc() {
        return 2;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        List<ParticleSpray> particles;
        Optional<class_1309> casterOption = Optional.of(ctx.getCastingEntity());
        if (casterOption.isPresent()) {
            particles = List.of(ParticleSpray.burst(casterOption.get().method_19538(), 1, 10));
        } else {
            particles = List.of();
        }

        int color = OperatorUtils.getIntBetween(args, 1, 0, 15, getArgc());
        class_2338 place = OperatorUtils.getBlockPos(args, 0, getArgc());
        try { ctx.assertPosInRangeForEditing(place); }
        catch (MishapBadLocation e) {
            MishapThrowerJava.throwMishap(new MishapBadLocation(e.getLocation(), e.getType()));
        }

        class_2968 AIPC = new class_2968(
            ctx.getWorld(),
            place,
            class_2350.field_11033,
            class_1799.field_8037,
            class_2350.field_11036
        );
        if (!ctx.getWorld().method_8320(place).method_26166(AIPC)) {
            MishapThrowerJava.throwMishap(MishapBadBlock.of(place, "replaceable"));
        };

        return new SpellAction.Result(
            new Spell(color, place, AIPC),
            MediaConstants.DUST_UNIT * 2,
            particles,
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final int color;
        public final class_2338 place;
        public final class_2968 AIPC;

        public Spell(int color, class_2338 place, class_2968 AIPC) {
            this.color = color;
            this.place = place;
            this.AIPC = AIPC;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            // wtf are those ixplat and other checks in the og
            // im not doin allat
            if (!ctx.getWorld().method_8477(this.place)) { return; }
            // "2 standards is too fucking many!"
            // "agreed, let's add one more and call it ParchmentMC!"
            // "yes! and to make it extra better, let's make it difficult
            //  to map to Yarn!"
            // "oh my god, that's such a brilliant idea i could kiss you
            //  you right now!"
            // and then the sons of satan kissed
            // /s
            class_1792 pigmentItem = ctx.getPigment().item().method_7909();
            class_1767 dye;
            // could be ItemAmethystAndCopperPigment or something
            if (!(pigmentItem instanceof ItemDyePigment)) {
                // well, fuck you too!
                dye = class_1767.field_7945;
            } else {
                dye = ((ItemDyePigment)pigmentItem).getDyeColor();
            }
            class_2680 state = ModBlocks.CONJURED_COLORABLE
                .method_9605(this.AIPC)
                .method_11657(COLOR, this.color)
                .method_11657(PIGMENT, (dye));
            ctx.getWorld().method_8652(
                this.place,
                state,
                class_2248.field_31036
            );
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
