package com.luxof.lapisworks.actions.misc;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.FrameForEach;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapNotEnoughArgs;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;

import com.luxof.lapisworks.MishapThrowerJava;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;

public class CubeExalt implements Action {
    public int getArgc() {
        return 4;
    }

    @Override
    public OperationResult operate(CastingEnvironment ctx, CastingImage img, SpellContinuation cont) {
        List<Iota> stack = new ArrayList<Iota>(img.getStack());
        if (stack.size() < getArgc()) {
            MishapThrowerJava.throwMishap(new MishapNotEnoughArgs(3, stack.size()));
        }
        int lastIdx = stack.size() - 1;
        SpellList intrs = OperatorUtils.getList(stack, lastIdx - 3, getArgc());
        class_243 pointA = OperatorUtils.getVec3(stack, lastIdx - 2, getArgc());
        class_243 pointB = OperatorUtils.getVec3(stack, lastIdx - 1, getArgc());

        CastingImage img2 = img.withUsedOp().copy(
            stack,
            img.getParenCount(),
            img.getParenthesized(),
            img.getEscapeNext(),
            img.getOpsConsumed(),
            img.getUserData()
        );
        SpellList datum = OperatorUtils.getBool(stack, lastIdx, getArgc()) ?
            generatePointsInHollowCube(pointA, pointB) :
            generatePointsInFilledCube(pointA, pointB);
        FrameForEach frame = new FrameForEach(datum, intrs, null, new ArrayList<Iota>());

        stack.remove(lastIdx);
        stack.remove(lastIdx - 1);
        stack.remove(lastIdx - 2);
        stack.remove(lastIdx - 3);

        return new OperationResult(img2, List.of(), cont.pushFrame(frame), HexEvalSounds.THOTH);
    }
    
    public static SpellList generatePointsInFilledCube(class_243 pointA, class_243 pointB) {
        List<Iota> points = new ArrayList<Iota>();
        // naming things is hard
        boolean a = pointA.field_1352 < pointB.field_1352;
        boolean b = pointA.field_1351 < pointB.field_1351;
        boolean c = pointA.field_1350 < pointB.field_1350;
        class_243 A = new class_243(
            a ? pointA.field_1352 : pointB.field_1352,
            b ? pointA.field_1351 : pointB.field_1351,
            c ? pointA.field_1350 : pointB.field_1350
        );
        class_243 B = new class_243(
            a ? pointB.field_1352 : pointA.field_1352,
            b ? pointB.field_1351 : pointA.field_1351,
            c ? pointB.field_1350 : pointA.field_1350
        );
        
        for (double z = A.field_1350; z < Math.ceil(B.field_1350); z++) {
            for (double y = A.field_1351; y < Math.ceil(B.field_1351); y++) {
                for (double x = A.field_1352; x < Math.ceil(B.field_1352); x++) {
                    points.add(new Vec3Iota(new class_243(Math.min(x, B.field_1352), Math.min(y, B.field_1351), Math.min(z, B.field_1350))));
                }
            }
        }

        return new SpellList.LList(points);
    }

    public static SpellList generatePointsInHollowCube(class_243 pointA, class_243 pointB) {
        List<Iota> points = new ArrayList<Iota>();

        // my brain is too small for the other approach (tried and skill issued)
        generatePointsInFilledCube(pointA, pointB).forEach((Iota anyIota) -> {
            class_243 any = ((Vec3Iota)anyIota).getVec3();
            if (any.field_1352 == pointA.field_1352 || any.field_1351 == pointA.field_1351 || any.field_1350 == pointA.field_1350 ||
                any.field_1352 == pointB.field_1352 || any.field_1351 == pointB.field_1351 || any.field_1350 == pointB.field_1350) {
                points.add(new Vec3Iota(any));
            }
        });

        return new SpellList.LList(points);
    }
}
