package com.luxof.lapisworks.actions.misc;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.castables.ConstMediaAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.BooleanIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.MishapThrowerJava;

import static com.luxof.lapisworks.Lapisworks.castRay;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3545;

public class VisibleDstl implements ConstMediaAction {
    @Override
    public List<Iota> execute(List<? extends Iota> args, CastingEnvironment ctx) {
        class_1297 entity = OperatorUtils.getEntity(args, 0, getArgc());
        class_2338 start = class_2338.method_49638(entity.method_33571());
        class_2338 end = OperatorUtils.getBlockPos(args, 1, getArgc());

        try {
            ctx.assertPosInRange(start);
            ctx.assertPosInRange(end);
        } catch (MishapBadLocation e) { MishapThrowerJava.throwMishap(e); }

        class_243 dir = end.method_46558().method_1020(start.method_46558()).method_1029();

        return List.of(new BooleanIota(
            entity.method_5720().method_1026(dir) >= 0.1
            && !castRay(
                start,
                class_2338.method_49638(end.method_46558().method_1020(dir)),
                pos -> 
                    new class_3545<>(pos, !ctx.getWorld().method_8320(pos).method_26225())
            ).method_15441()
        ));
    }

    @Override
    public CostMediaActionResult executeWithOpCount(List<? extends Iota> arg0, CastingEnvironment arg1) {
        return ConstMediaAction.DefaultImpls.executeWithOpCount(this, arg0, arg1);
    }

    @Override
    public int getArgc() {
        return 2;
    }

    @Override
    public long getMediaCost() {
        return (long)(MediaConstants.DUST_UNIT * 0.01);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return ConstMediaAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
