package com.luxof.lapisworks.blocks.entities;

import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.blocks.MediaCondenser;
import com.luxof.lapisworks.blocks.stuff.LinkableMediaBlock;
import com.luxof.lapisworks.init.ModBlocks;

import static com.luxof.lapisworks.Lapisworks.LOGGER;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class MediaCondenserEntity extends class_2586 implements LinkableMediaBlock {
    public MediaCondenserEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.MEDIA_CONDENSER_ENTITY_TYPE, pos, state);
    }

    public long media = 0;
    public long mediaCap = MediaConstants.DUST_UNIT * 64;
    public HashSet<class_2338> linkedCondensers = new HashSet<>();

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) return;
        class_3218 sw = (class_3218)world;
        int filledState;
        try {
            filledState = Math.min(14, (int)Math.floor(media / (mediaCap / 15.0)));
        } catch (ArithmeticException e) { return; } // btw: does not return..????
        if (filledState == state.method_11654(MediaCondenser.FILLED)) return;
        sw.method_8501(
            pos,
            state.method_11657(
                MediaCondenser.FILLED,
                filledState
            )
        );
    }

    private List<Integer> posToInts(HashSet<class_2338> posList) {
        return posList.stream().flatMap(
            pos -> Stream.of(pos.method_10263(), pos.method_10264(), pos.method_10260())
        ).toList();
    }
    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("media", media);
        nbt.method_10544("max", mediaCap);
        nbt.method_10572(
            "links",
            posToInts(linkedCondensers)
        );
    }

    private HashSet<class_2338> intsToPos(int[] intArray) {
        HashSet<class_2338> posList = new HashSet<>();
        int x = 0;
        int y = 0;
        int part = 0;
        for (int integer : intArray) {
            switch (part) {
                case 0 -> x = integer;
                case 1 -> y = integer;
                case 2 -> posList.add(new class_2338(x, y, integer));
                default -> {}
            };
            part = (part + 1) % 3;
        }
        return posList;
    }
    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        media = nbt.method_10537("media");
        mediaCap = nbt.method_10537("max");
        linkedCondensers = intsToPos(nbt.method_10561("links"));
    }

    @Override @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }



    @Override public void addLink(class_2338 pos) { linkedCondensers.add(pos); }
    @Override public void removeLink(class_2338 pos) { linkedCondensers.remove(pos); }
    @Override public boolean isLinkedTo(class_2338 pos) { return linkedCondensers.contains(pos); }
    @Override public Set<class_2338> getLinks() { return linkedCondensers; }
    @Override public int getNumberOfLinks() { return linkedCondensers.size(); }
    @Override public class_2338 getThisPos() { return this.method_11016(); }
    @Override
    public long depositMedia(long amount, boolean simulate) {
        long prevMedia = media;

        long nowMedia = Math.min(media + amount, mediaCap);
        if (!simulate) {
            media = nowMedia;
            this.method_5431();
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31028);
        }

        return nowMedia - prevMedia;
    }
    @Override
    public long withdrawMedia(long amount, boolean simulate) {
        long prevMedia = media;

        long nowMedia = Math.max(media - amount, 0);
        LOGGER.info("withdrawal request of " + amount + "! " + (prevMedia - nowMedia) + " left!");
        if (!simulate) {
            media = nowMedia;
            this.method_5431();
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31028);
        }

        return prevMedia - nowMedia;
    }
}
