package com.luxof.lapisworks.blocks.entities;

import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.EntityIota;

import com.luxof.lapisworks.init.ModBlocks;
import com.luxof.lapisworks.mixinsupport.ControlCircleTickSpeed;

import static com.luxof.lapisworks.Lapisworks.LOGGER;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class SimpleImpetusEntity extends BlockEntityAbstractImpetus {
    private String angSig = "";
    // because bookkeeper's - exists
    private boolean tuned = false;
    private UUID plr = null;

    public static final String TAG_TUNED_PAT = "tuned_pattern";
    public static final String TAG_IS_TUNED = "tuned";
    public static final String TAG_PLAYER = "player";

    public SimpleImpetusEntity(
        class_2338 pWorldPosition, class_2680 pBlockState
    ) { super(ModBlocks.SIMPLE_IMPETUS_ENTITY_TYPE, pWorldPosition, pBlockState); }

    @Override
    public void startExecution(@Nullable class_3222 sp) {
        super.startExecution(getPlayer());

        // check if we're actually going to cast
        if (this.executionState == null) return;

        ((ControlCircleTickSpeed)this.executionState).setForcedTPT(4);
        CastingImage img = this.executionState.currentImage;
        this.executionState.currentImage.copy(
            List.of(new EntityIota(sp)),
            img.getParenCount(),
            img.getParenthesized(),
            img.getEscapeNext(),
            img.getOpsConsumed(),
            img.getUserData()
        );
    }

    @Override
    protected void saveModData(class_2487 nbt) {
        super.saveModData(nbt);
        nbt.method_10582(TAG_TUNED_PAT, angSig);
        nbt.method_10556(TAG_IS_TUNED, tuned);
        if (plr != null) {
            nbt.method_25927(TAG_PLAYER, plr);
        } else {
            LOGGER.warn("Player was null in a Simple Impetus. Don't do that!");
        }
    }

    @Override
    protected void loadModData(class_2487 nbt) {
        super.loadModData(nbt);
        angSig = nbt.method_10558(TAG_TUNED_PAT);
        tuned = nbt.method_10577(TAG_IS_TUNED);
        if (nbt.method_10545(TAG_PLAYER)) {
            plr = nbt.method_25926(TAG_PLAYER);
        } else {
            LOGGER.warn("Player was null in a Simple Impetus. Don't do that!");
        }
    }

    /** returns whether or not the simple impetus was tuned to the pattern in question.
     * This return value is useful for making certain patterns do no-ops when they were tuned.
     * <p><code>isValidPat</code> makes sure an untuned Simple Impetus doesn't go off on an invalid
     * pattern. */
    public boolean tryTrigger(String pat, boolean isValidPat, @Nullable class_3222 sp) {
        // so == checks identity, while .equals(Object) checks whatever the type on the left says
        // it should, so you should use .equals(Object) whenever it's a non-primitive. Qhar??
        if ((!tuned && isValidPat) || angSig.equals(pat)) startExecution(sp);
        return tuned && angSig.equals(pat);
    }

    public void tune(String pat, boolean tuneOrNot) {
        // looks explainable in the game data when i clear angSig too.
        tuned = tuneOrNot;
        angSig = tuneOrNot ? pat : "";
    }

    public String getTuned() { return angSig; }

    public boolean getIsTuned() { return tuned; }

    @Nullable
    public class_3222 getPlayer() {
        if (plr == null) return null;
        return (class_3222)this.field_11863.method_18470(plr);
    }

    public void setPlayer(class_3222 sp) { plr = sp.method_5667(); }
}
