package com.luxof.lapisworks.blocks.stuff;

import com.luxof.lapisworks.inv.BrewerInv;
import com.luxof.lapisworks.recipes.BrewingRec;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3908;

import static net.minecraft.class_1799.field_8037;

import org.jetbrains.annotations.Nullable;

public abstract class AbstractBrewerEntity extends class_2586 implements class_3908, class_1263 {
    // logic similar to og brewing stand. no guarantee tho
    public int fuel = 0;
    public int brewTime = -1; // -1 means not brewing btw!
    public final int maxFuel;
    public final int maxBrewTime;
    protected List<BrewingRec> currentRecipes = new ArrayList<>();
    public BrewerInv inv = new BrewerInv(
        field_8037.method_7972(), field_8037.method_7972(), List.of(field_8037.method_7972(), field_8037.method_7972(), field_8037.method_7972())
    );

    public AbstractBrewerEntity(
        class_2591<?> type,
        class_2338 pos,
        class_2680 state,
        int maxFuel,
        int maxBrewTime
    ) {
        super(type, pos, state);
        this.maxFuel = maxFuel;
        this.maxBrewTime = maxBrewTime;
    }
    public AbstractBrewerEntity(
        class_2591<?> type,
        class_2338 pos,
        class_2680 state,
        int maxFuel,
        int maxBrewTime,
        BrewerInv inv
    ) {
        this(type, pos, state, maxFuel, maxBrewTime);
        this.inv = inv;
    }

    protected void attemptRefuel() {
        if (currentRecipes.size() <= 0) return;
        if (fuel == 0) {
            if (inv.blaze.method_7960() || inv.blaze.method_7947() <= 0) return;
            inv.blaze.method_7934(1);
            fuel = maxFuel;
            method_5431();
        }
        if (brewTime <= 0 && fuel > 0) {
            fuel -= 1;
            brewTime = maxBrewTime;
            method_5431();
        }
    }

    protected List<BrewingRec> updateRecipes(BrewerInv inv) {
        return new ArrayList<>(
            field_11863.method_8433().method_17877(BrewingRec.Type.INSTANCE, inv, field_11863)
        );
    }

    protected void craft(BrewingRec recipe, BrewerInv inv) {
        List<class_1799> crafted = recipe.craft(inv);
        inv.brewingInto = new ArrayList<>(crafted.subList(0, 3));
        try {
            inv.input = crafted.get(6); // TODO: fix crash arising from consuming ingredients
        } catch (Exception e) {
            return;
        }

        for (class_1799 stack : crafted.subList(3, 6)) {
            if (stack.method_7960()) continue;
            class_1542 item = new class_1542(field_11863, field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), stack);
            field_11863.method_8649(item);
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (brewTime == 0) {
            if (fuel > 0) {
                fuel -= 1;
                brewTime = maxBrewTime;
            }
            for (BrewingRec recipe : currentRecipes) {
                craft(recipe, inv);
            }
            currentRecipes.clear();
        }
        attemptRefuel();
        currentRecipes = updateRecipes(inv);
        if (currentRecipes.size() == 0) return;

        if (brewTime >= 0) brewTime -= 1;
        method_5431();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        inv.writeNbt(nbt);
        nbt.method_10569("fuel", fuel);
        nbt.method_10569("brewTime", brewTime);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        inv.readNbt(nbt);
        fuel = nbt.method_10550("fuel");
        brewTime = nbt.method_10550("brewTime");
    }

    @Override @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }

    @Override public void method_5448() { inv.method_5448(); }
    @Override public boolean method_5443(class_1657 player) { return inv.method_5443(player); }
    @Override public class_1799 method_5438(int slot) { return inv.method_5438(slot); }
    @Override public boolean method_5442() { return inv.method_5442(); }
    @Override public class_1799 method_5441(int slot) { return inv.method_5441(slot); }
    @Override public class_1799 method_5434(int slot, int amount) { return inv.method_5434(slot, amount); }
    @Override public void method_5447(int slot, class_1799 stack) { inv.method_5447(slot, stack); }
    @Override public int method_5439() { return inv.method_5439(); }
}
