package com.luxof.lapisworks.client.screens;

import com.luxof.lapisworks.recipes.BrewingRec;

import static com.luxof.lapisworks.Lapisworks.id;

import com.mojang.blaze3d.systems.RenderSystem;

import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_757;

public class EnchBrewerScreen extends class_465<EnchBrewerScreenHandler> {
    private static final class_2960 TEXTURE = id("textures/gui/brewer/enchanted.png");

    public EnchBrewerScreen(EnchBrewerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    private void drawIsBrewing(class_332 context, int x, int y) {
        int isBrewingIconX = x + 102;
        int isBrewingIconY = y + 30;

        int yesBrewingIconX = 176;
        int yesBrewingIconY = 10;
        context.method_25302(
            TEXTURE,
            isBrewingIconX,
            isBrewingIconY,
            yesBrewingIconX,
            yesBrewingIconY,
            18,
            18
        );
    }

    private void drawFuelRod(class_332 ctx, int x, int y) {
        int fuel = this.field_2797.getFuel();
        int rodHeight = 10;
        int filledHeight = fuel; // fuel is 0-10 anyway

        int rodX = x + 79;
        int rodY = y + 34 + (rodHeight - filledHeight);
        int rodU = 176;
        int rodV = rodHeight - filledHeight;

        ctx.method_25302(
            TEXTURE,
            rodX,
            rodY,
            rodU,
            rodV,
            3,
            filledHeight
        );
    }

    private void drawBrewTimeRod(class_332 ctx, int x, int y) {
        int brewTime = this.field_2797.getBrewTime();
        if (brewTime <= 0) return; // i don't wanna know what happens here when brewTime is -1
        int rodHeight = 10;
        int maxBrewTime = 200;
        int filledHeight = brewTime * (rodHeight / maxBrewTime);

        int rodX = x + 92;
        int rodY = y + 34 + (rodHeight - filledHeight);
        int rodU = 179;
        int rodV = rodHeight - filledHeight;

        ctx.method_25302(
            TEXTURE,
            rodX,
            rodY,
            rodU,
            rodV,
            3,
            filledHeight
        );
    }

    private void drawBrewingRods(class_332 ctx, int x, int y) {
        List<BrewingRec> recipes = field_2797.getRecipes();
        List<class_1799> brewingInto = field_2797.inventory.brewingInto;
        drawBrewingRod(ctx, x + 73, y + 57, 5, 3, brewingInto.get(0), recipes);
        drawBrewingRod(ctx, x + 86, y + 62, 3, 1, brewingInto.get(1), recipes);
        drawBrewingRod(ctx, x + 96, y + 57, 5, 3, brewingInto.get(2), recipes);
    }

    private void drawBrewingRod(
        class_332 ctx,
        int rodX,
        int rodY,
        int width,
        int height,
        class_1799 stack,
        List<BrewingRec> recipes
    ) {
        for (BrewingRec recipe : recipes) {
            if (recipe.isItemBrew()) {
                if (!recipe.getFrom().left().get().ingredient.method_8093(stack)) continue;
                drawOnBrewingRod(
                    ctx,
                    rodX,
                    rodY,
                    width,
                    height,
                    class_1844.method_8064(recipe.getOutput().left().get())
                );
                break;
            } else {
                class_1842 fromPotion = class_1842.method_8048(recipe.getFrom().right().get());
                if (class_1844.method_8063(stack) != fromPotion) continue;
                drawOnBrewingRod(
                    ctx,
                    rodX,
                    rodY,
                    width,
                    height,
                    class_1844.method_8062(class_1842.method_8048(recipe.getOutput().right().get()))
                );
                break;
            }
        }
    }

    private int darken(int color) {
        int R = color & 255; // get lower 8 bits from the 24
        int G = color & (255 * 256); // get mid 8 bits
        int B = color & (255 * 256 * 256); // get upper 8 bits
        return (
            Math.max(R - 68, 0) + // R - 0x44
            Math.max(G - 68 * 256, 0) +
            Math.max(B - 68 * 256 * 256, 0)
        );
    }

    private void drawOnBrewingRod(
        class_332 ctx,
        int rodX,
        int rodY,
        int width,
        int height,
        int color // hex code
    ) {
        int border = darken(color);
        if (width > height) {
            ctx.method_25292(rodX, rodX+width, rodY, border);
            ctx.method_25292(rodX, rodX+width, rodY+height-1, border);
            for (int y = rodY; y < rodY+height-1; y++) {
                ctx.method_25301(rodX, rodX+width, y, color);
            }
        } else {
            ctx.method_25301(rodX, rodY, rodY+height, border);
            ctx.method_25301(rodX+width-1, rodY, rodY+height, border);
            for (int x = rodX; x < rodX+width-1; x++) {
                ctx.method_25301(x, rodY, rodY+height, color);
            }
        }
    }

    @Override
    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        RenderSystem.setShaderTexture(0, TEXTURE);
        int x = (field_22789 - field_2792) / 2;
        int y = (field_22790 - field_2779) / 2;
        context.method_25302(TEXTURE, x, y, 0, 0, field_2792, field_2779);

        if (this.field_2797.getIsBrewing()) {
            drawIsBrewing(context, x, y);
            drawBrewingRods(context, x, y);
        };
        drawFuelRod(context, x, y);
        drawBrewTimeRod(context, x, y);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        method_2380(context, mouseX, mouseY);
    }
    
    @Override
    protected void method_25426() {
        super.method_25426();
        field_25267 = (field_2792 - field_22793.method_27525(field_22785)) / 2;
    }
}
