package com.luxof.lapisworks.client.screens;

import at.petrak.hexcasting.common.lib.HexItems;

import com.luxof.lapisworks.client.slots.LapisPotionIngredientSlot;
import com.luxof.lapisworks.client.slots.SpecificItemSlot;
import com.luxof.lapisworks.client.slots.TagSlot;
import com.luxof.lapisworks.init.ModScreens;
import com.luxof.lapisworks.inv.EnchBrewerInv;
import com.luxof.lapisworks.recipes.BrewingRec;

import static com.luxof.lapisworks.LapisworksIDs.POTION_TAG;
import static com.luxof.lapisworks.inv.EnchBrewerInv.IDX_BLAZE;
import static com.luxof.lapisworks.inv.EnchBrewerInv.IDX_BREWINGINTO_1;
import static com.luxof.lapisworks.inv.EnchBrewerInv.IDX_BREWINGINTO_2;
import static com.luxof.lapisworks.inv.EnchBrewerInv.IDX_BREWINGINTO_3;
import static com.luxof.lapisworks.inv.EnchBrewerInv.IDX_INPUT;
import static com.luxof.lapisworks.inv.EnchBrewerInv.IDX_DUST;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3545;

import static net.minecraft.class_1799.field_8037;

public class EnchBrewerScreenHandler extends class_1703 {
    public final EnchBrewerInv inventory;
    private final Supplier<class_3545<Integer, Integer>> fuelAndBrewTimeSupplier;
    private final Supplier<List<BrewingRec>> recipesSupplier;

    public EnchBrewerScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, new EnchBrewerInv(), () -> new class_3545<>(0, 0), () -> List.of());
    }

    public EnchBrewerScreenHandler(
        int syncId,
        class_1661 plrInv,
        EnchBrewerInv blockInv,
        Supplier<class_3545<Integer, Integer>> fuelAndBrewTimeSupplier,
        Supplier<List<BrewingRec>> recipesSupplier
    ) {
        super(ModScreens.ENCH_BREWER_SCREEN_HANDLER, syncId);
        method_17359(blockInv, 5);
        this.inventory = blockInv;
        this.fuelAndBrewTimeSupplier = fuelAndBrewTimeSupplier;
        this.recipesSupplier = recipesSupplier;

        class_1937 world = plrInv.field_7546.method_37908();
        this.method_7621(new SpecificItemSlot(class_1802.field_8183, inventory, IDX_BLAZE, 79, 45));
        this.method_7621(new LapisPotionIngredientSlot(world, inventory, IDX_INPUT, 79, 17));
        this.method_7621(new TagSlot(POTION_TAG, inventory, IDX_BREWINGINTO_1, 56, 57));
        this.method_7621(new TagSlot(POTION_TAG, inventory, IDX_BREWINGINTO_2, 79, 64));
        this.method_7621(new TagSlot(POTION_TAG, inventory, IDX_BREWINGINTO_3, 102, 57));
        this.method_7621(new SpecificItemSlot(HexItems.AMETHYST_DUST, inventory, IDX_DUST, 56, 31));

        // hell no i'm not even gonna ATTEMPT to understand the fabric wiki's shit
        // The player inventory
        for (int m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735(plrInv, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        // The player Hotbar
        for (int m = 0; m < 9; ++m) {
            this.method_7621(new class_1735(plrInv, m, 8 + m * 18, 142));
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slotIdx) {
        // i have little clue why this is the way it is.

        class_1735 slot = this.method_7611(slotIdx);
        if (slot == null || !slot.method_7681()) return field_8037.method_7972();
        class_1799 ogStack = slot.method_7677();
        class_1799 newStack = ogStack.method_7972();
        if (ogStack.method_7960()) return ogStack;

        if (slotIdx < this.inventory.method_5439()) {
            if (!method_7616(newStack, this.inventory.method_5439(), this.field_7761.size(), true))
                return field_8037.method_7972();

        } else if (!method_7616(newStack, 0, this.inventory.method_5439(), false))
            return field_8037.method_7972();


        if (newStack.method_7960()) slot.method_48931(field_8037.method_7972());
        else slot.method_7668();

        slot.method_7667(player, ogStack);
        return ogStack;
    }

    @Override
    public boolean method_7597(class_1657 player) { return this.inventory.method_5443(player); }

    public class_3545<Integer, Integer> getFuelAndBrewTime() { return this.fuelAndBrewTimeSupplier.get(); }
    public int getFuel() { return this.fuelAndBrewTimeSupplier.get().method_15442(); }
    public int getBrewTime() { return this.fuelAndBrewTimeSupplier.get().method_15441(); }
    public boolean getIsBrewing() {
        class_3545<Integer, Integer> fuelAndBrewTime = this.fuelAndBrewTimeSupplier.get();
        return fuelAndBrewTime.method_15442() > 0 || fuelAndBrewTime.method_15441() > 0;
    }
    public List<BrewingRec> getRecipes() { return this.recipesSupplier.get(); }
}
