package com.luxof.lapisworks.init;

import com.luxof.lapisworks.items.AmelJar;
import com.luxof.lapisworks.items.AmelRing;
import com.luxof.lapisworks.items.AmelStaff;
import com.luxof.lapisworks.items.CastingRing;
//import com.luxof.lapisworks.items.Chalk;
import com.luxof.lapisworks.items.DiamondSword;
import com.luxof.lapisworks.items.FocusNecklace;
import com.luxof.lapisworks.items.GeodeDowser;
import com.luxof.lapisworks.items.GoldSword;
import com.luxof.lapisworks.items.IronSword;
import com.luxof.lapisworks.items.JumpSlateItem;
import com.luxof.lapisworks.items.PartiallyAmelStaff;
import com.luxof.lapisworks.items.WizardDiaries;
import com.luxof.lapisworks.items.shit.AmelSword;

import static com.luxof.lapisworks.Lapisworks.id;
import static com.luxof.lapisworks.LapisworksIDs.LAPISMAGICSHITGROUPTEXT;
import static com.luxof.lapisworks.LapisworksIDs.LAPIS_MAGIC_SHIT_GROUP;

import java.util.ArrayList;
import java.util.List;

import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_7923;

public class ModItems {
    private static FabricItemSettings fullStack = new FabricItemSettings().method_7889(64);
    private static FabricItemSettings unstackable = new FabricItemSettings().method_7889(1);
    
    public static final class_1792 AMEL_ITEM = new class_1792(fullStack);
    public static final class_1792 AMEL2_ITEM = new class_1792(fullStack);
    public static final class_1792 AMEL3_ITEM = new class_1792(fullStack);
    public static final class_1792 AMEL4_ITEM = new class_1792(fullStack);
    public static final class_1792 AMEL_STAFF = new AmelStaff(unstackable);
    public static final PartiallyAmelStaff PARTAMEL_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_ACACIA_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_BAMBOO_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_BIRCH_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_CHERRY_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_CRIMSON_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_DARK_OAK_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_EDIFIED_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_JUNGLE_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_MANGROVE_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_MINDSPLICE_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_OAK_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_SPRUCE_STAFF = new PartiallyAmelStaff();
    public static final PartiallyAmelStaff PARTAMEL_WARPED_STAFF = new PartiallyAmelStaff();
    public static final class_1792 AMEL_RING = new AmelRing(unstackable);
    public static final class_1792 AMEL_RING2 = new AmelRing(unstackable);
    public static final CastingRing CASTING_RING = new CastingRing(unstackable);
    public static final AmelSword DIAMOND_SWORD = new DiamondSword();
    public static final AmelSword IRON_SWORD = new IronSword();
    public static final AmelSword GOLD_SWORD = new GoldSword();
    public static final class_1792 WIZARD_DIARIES = new WizardDiaries(unstackable);
    public static final class_1792 MIND = new class_1747(ModBlocks.MIND_BLOCK, fullStack);
    public static final class_1792 LIVE_JUKEBOX = new JumpSlateItem(ModBlocks.LIVE_JUKEBOX_BLOCK, fullStack);
    public static final class_1792 JUMP_SLATE_AM1 = new JumpSlateItem(ModBlocks.JUMP_SLATE_AM1, fullStack);
    public static final class_1792 JUMP_SLATE_AM2 = new JumpSlateItem(ModBlocks.JUMP_SLATE_AM2, fullStack);
    public static final class_1792 JUMP_SLATE_AMETH = new JumpSlateItem(ModBlocks.JUMP_SLATE_AMETH, fullStack);
    public static final class_1792 JUMP_SLATE_LAPIS = new JumpSlateItem(ModBlocks.JUMP_SLATE_LAPIS, fullStack);
    public static final class_1792 REBOUND_SLATE_1 = new JumpSlateItem(ModBlocks.REBOUND_SLATE_1, fullStack);
    public static final class_1792 REBOUND_SLATE_2 = new JumpSlateItem(ModBlocks.REBOUND_SLATE_2, fullStack);
    public static final class_1792 AMEL_JAR = new AmelJar(unstackable, 256, false);
    public static final class_1792 ENERGY_CONTAINER = new AmelJar(unstackable, 1024, true);
    public static final GeodeDowser GEODE_DOWSER = new GeodeDowser(unstackable);
    public static final class_1792 SIMPLE_IMPETUS = new class_1747(ModBlocks.SIMPLE_IMPETUS, fullStack);
    //public static final Chalk CHALK = new Chalk(new FabricItemSettings().maxCount(1).maxDamage(1024));
    public static final FocusNecklace FOCUS_NECKLACE = new FocusNecklace(unstackable);
    public static final FocusNecklace FOCUS_NECKLACE2 = new FocusNecklace(unstackable);
    // 2 dummies i use for trinket rendering (model predicate providers don't work for no reason)
    public static final FocusNecklace FOCUS_NECKLACE_WORN = new FocusNecklace(unstackable);
    public static final FocusNecklace FOCUS_NECKLACE2_WORN = new FocusNecklace(unstackable);
    public static final class_1792 ENCH_BREWER = new class_1747(ModBlocks.ENCH_BREWER, fullStack);
    public static final class_1747 MEDIA_CONDENSER = new class_1747(ModBlocks.MEDIA_CONDENSER, unstackable);
    public static final class_1747 UNCRAFTED_CONDENSER = new class_1747(ModBlocks.UNCRAFTED_CONDENSER, fullStack);

    private static List<String> itemNames = new ArrayList<>(List.of(
        "amel",
        "amel2",
        "amel3",
        "amel4",
        "staves/amel_staff",
        "staves/incomplete/generic",
        "staves/incomplete/acacia",
        "staves/incomplete/bamboo",
        "staves/incomplete/birch",
        "staves/incomplete/cherry",
        "staves/incomplete/crimson",
        "staves/incomplete/dark_oak",
        "staves/incomplete/edified",
        "staves/incomplete/jungle",
        "staves/incomplete/mangrove",
        "staves/incomplete/mindsplice",
        "staves/incomplete/oak",
        "staves/incomplete/spruce",
        "staves/incomplete/warped",
        "staves/amel_ring",
        "staves/amel_ring2",
        "staves/ring",
        "amel_constructs/diamond_sword",
        "amel_constructs/iron_sword",
        "amel_constructs/gold_sword",
        "wizard_diaries",
        "mind",
        "amel_constructs/live_jukebox",
        "amel_constructs/jumpslate/am1",
        "amel_constructs/jumpslate/am2",
        "amel_constructs/jumpslate/ameth",
        "amel_constructs/jumpslate/lapis",
        "amel_constructs/jumpslate/rebound_1",
        "amel_constructs/jumpslate/rebound_2",
        "amel_jar",
        "energy_container",
        "amel_constructs/geode_dowser",
        "amel_constructs/simple_impetus",
        //"chalk",
        "amel_constructs/focus_necklace/1",
        "amel_constructs/focus_necklace/2",
        "amel_constructs/focus_necklace/1_worn",
        "amel_constructs/focus_necklace/2_worn",
        "amel_constructs/enchbrewer",
        "media_condenser_unit",
        "uncrafted_condenser"
    ));
    private static List<class_1792> items = new ArrayList<>(List.of(
        AMEL_ITEM,
        AMEL2_ITEM,
        AMEL3_ITEM,
        AMEL4_ITEM,
        AMEL_STAFF,
        PARTAMEL_STAFF,
        PARTAMEL_ACACIA_STAFF,
        PARTAMEL_BAMBOO_STAFF,
        PARTAMEL_BIRCH_STAFF,
        PARTAMEL_CHERRY_STAFF,
        PARTAMEL_CRIMSON_STAFF,
        PARTAMEL_DARK_OAK_STAFF,
        PARTAMEL_EDIFIED_STAFF,
        PARTAMEL_JUNGLE_STAFF,
        PARTAMEL_MANGROVE_STAFF,
        PARTAMEL_MINDSPLICE_STAFF,
        PARTAMEL_OAK_STAFF,
        PARTAMEL_SPRUCE_STAFF,
        PARTAMEL_WARPED_STAFF,
        AMEL_RING,
        AMEL_RING2,
        CASTING_RING,
        DIAMOND_SWORD,
        IRON_SWORD,
        GOLD_SWORD,
        WIZARD_DIARIES,
        MIND,
        LIVE_JUKEBOX,
        JUMP_SLATE_AM1,
        JUMP_SLATE_AM2,
        JUMP_SLATE_AMETH,
        JUMP_SLATE_LAPIS,
        REBOUND_SLATE_1,
        REBOUND_SLATE_2,
        AMEL_JAR,
        ENERGY_CONTAINER,
        GEODE_DOWSER,
        SIMPLE_IMPETUS,
        //CHALK,
        FOCUS_NECKLACE,
        FOCUS_NECKLACE2,
        FOCUS_NECKLACE_WORN,
        FOCUS_NECKLACE2_WORN,
        ENCH_BREWER,
        MEDIA_CONDENSER,
        UNCRAFTED_CONDENSER
    ));

    public static class_1761 LapisMagicShitGroup;

    public static void init_shit() {
        LapisMagicShitGroup = FabricItemGroup.builder()
            .method_47320(() -> new class_1799(AMEL_ITEM))
            .method_47321(LAPISMAGICSHITGROUPTEXT)
            .method_47317((context, entries) -> {
                items.forEach(
                    (class_1792 item) -> {
                        entries.method_45421(item);
                    }
                );
            })
        .method_47324();
        class_2378.method_10230(
            class_7923.field_44687,
            LAPIS_MAGIC_SHIT_GROUP,
            LapisMagicShitGroup
        );
        for (int i = 0; i < items.size(); i++) {
            register(itemNames.get(i), items.get(i));
        }
    }

    private static void register(String name, class_1792 item) {
        class_2378.method_10230(class_7923.field_41178, id(name), item);
    }

    public static <T extends class_1792> T registerItem(String name, T item) {
        itemNames.add(name);
        items.add(item);
        return item;
    }
}
