package com.luxof.lapisworks.interop.hexal.SMindInfusions;

import at.petrak.hexcasting.api.casting.ParticleSpray;

import com.luxof.lapisworks.Lapisworks;
import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.VAULT.Flags;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.init.Mutables.SMindInfusion;
import com.luxof.lapisworks.interop.hexal.Lapisal;
import com.luxof.lapisworks.mishaps.MishapNotEnoughItems;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1767;
import net.minecraft.class_1937.class_7867;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7298;

import static com.luxof.lapisworks.LapisworksIDs.AMEL;
import static com.luxof.lapisworks.LapisworksIDs.CLUEDIN_ADVANCEMENT;

import ram.talia.hexal.common.entities.WanderingWisp;
import ram.talia.hexal.common.lib.HexalBlocks;

public class OpenSlipway extends SMindInfusion {
    private int amelCount = 0;
    private int neededAmel = 48;

    @Override
    public boolean testBlock() {
        if (!ctx.isEnlightened()) return false;
        amelCount = vault.fetch(Mutables::isAmel, Flags.PRESET_Stacks_InvItem_UpToHotbar);
        return ctx.getWorld().method_8320(blockPos).method_27852(HexalBlocks.SLIPWAY);
    }

    @Override
    public void mishapIfNeeded() {
        if (amelCount >= neededAmel) return;
        MishapThrowerJava.throwMishap(new MishapNotEnoughItems(AMEL, amelCount, neededAmel));
    }

    @Override
    public void accept() {
        class_3218 world = ctx.getWorld();
        class_1309 castingEntity = ctx.getCastingEntity();
        if (castingEntity instanceof class_3222 sp) {
            class_161 cluedIn = sp.method_5682().method_3851().method_12896(CLUEDIN_ADVANCEMENT);
            if (!sp.method_14236().method_12882(cluedIn).method_740())
                sp.method_14236().method_12878(cluedIn, "grant");
        }
        vault.drain(Mutables::isAmel, neededAmel, Flags.PRESET_StacksUptoHotbar_InvItemUptoHands);
        ParticleSpray particles = ParticleSpray.burst(blockPos.method_46558(), 5, 50);
        particles.sprayParticles(world, Lapisworks.getPigmentFromDye(class_1767.field_7945));
        world.method_8437(
            null,
            blockPos.method_10263() + 0.5,
            blockPos.method_10264() + 0.5,
            blockPos.method_10260() + 0.5, 0.25F,
            class_7867.field_40888
        );
        world.method_8501(blockPos, Lapisal.ENCH_SLIPWAY.method_9564());
        world.method_8396(
            null,
            blockPos,
            class_3417.field_14981,
            class_3419.field_15245,
            2.0f,
            0.85f
        );
        class_243 riftPos = blockPos.method_46558();
        class_238 aabb = class_238.method_30048(riftPos, 32.0, 32.0, 32.0);
        for (
            class_1309 entity :
            world.method_8390(
                class_1309.class,
                aabb,
                any -> !(any instanceof class_7298)
            )
        ) {
            class_243 entPos = entity.method_19538();
            class_243 push = entPos.method_1020(riftPos).method_1029().method_1021(
                2.5 * Math.max(1.0, (1.0 / riftPos.method_1020(entPos).method_1033()) / 5.0)
            );
            entity.method_45319(push);
            entity.field_6037 = true;
        }

        for (int i = 0; i < world.field_9229.method_39332(2, 10); i++) {
            WanderingWisp wisp = new WanderingWisp(world, riftPos);
            wisp.setPigment(Lapisworks.getRandomPigment(world.field_9229));
            world.method_8649(wisp);
        }
    }
}
