package com.luxof.lapisworks.interop.hexical.blocks;

import at.petrak.hexcasting.api.utils.NBTHelper;

import com.luxof.lapisworks.blocks.entities.MindEntity;
import com.luxof.lapisworks.init.ModBlocks;
import com.luxof.lapisworks.interop.hexical.Lapixical;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

import static com.luxof.lapisworks.LapisworksIDs.IS_IN_CRADLE;

public class Cradle extends class_2237 {
    public static final class_265 SHAPE = class_2248.method_9541(
        6, 0, 0,
        10, 16, 10
    );

    public Cradle() { super(class_2251.method_9630(class_2246.field_27171)); }
 
	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {}

    @Override
    public class_265 method_9530(class_2680 bs, class_1922 bv, class_2338 bp, class_3726 ctx) {
        return class_259.method_1077();
    }

    @Override
    public class_1269 method_9534(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hit
    ) {
        CradleEntity bE = (CradleEntity)world.method_8321(pos);
        class_1799 prevStack = bE.method_5438(0);
        bE.method_5447(0, player.method_5998(hand));
        player.method_6122(hand, prevStack);
        NBTHelper.putBoolean(bE.method_5438(0), IS_IN_CRADLE, true);
        NBTHelper.remove(prevStack, IS_IN_CRADLE);
        bE.updateItemEntity();
        bE.method_5431();
        if (!world.field_9236) {
            world.method_8413(pos, state, state, class_2248.field_31036);
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 bs) {
        return new CradleEntity(pos, bs);
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(
        class_1937 world,
        class_2680 state,
        class_2591<T> type
    ) {
        // checkType() makes me required to do an "unsafe cast" for whatever reason
        if (type == Lapixical.CRADLE_ENTITY_TYPE) return CradleEntity::tick;
        if (type == ModBlocks.MIND_ENTITY_TYPE) { return MindEntity::tick; }
        else { return null; }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() == newState.method_26204()) return;
        CradleEntity bE = (CradleEntity)world.method_8321(pos);
        if (bE.heldEntity != null) {
            bE.heldEntity.method_31472();
            bE.heldEntity = null;
        }
        class_1799 stack = bE.method_5438(0);
        if (NBTHelper.contains(stack, IS_IN_CRADLE)) {
            NBTHelper.remove(stack, IS_IN_CRADLE);
        }
        if (!stack.method_7960()) {
            world.method_8649(
                new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack)
            );
        }
        bE.method_5431();
    }
}
