package com.luxof.lapisworks.interop.hextended.items;

import at.petrak.hexcasting.api.utils.NBTHelper;

import static com.luxof.lapisworks.Lapisworks.getAllHands;
import static com.luxof.lapisworks.Lapisworks.prettifyVec3d;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

import com.luxof.lapisworks.init.Mutables.Mutables;

public class AmelOrb extends class_1792 {
    private static final class_1793 defaultSettings = new class_1792.class_1793().method_7889(1);
    public AmelOrb() { super(defaultSettings); }
    public AmelOrb(class_1793 settings) {super(settings); }

    private static final String PLACE_IN_AMBIT_X = "place_in_ambit_X";
    private static final String PLACE_IN_AMBIT_Y = "place_in_ambit_Y";
    private static final String PLACE_IN_AMBIT_Z = "place_in_ambit_Z";
    private static final String PLACE_IN_AMBIT_IS_NULL = "place_in_ambit_is_null";
    public double ambitRadius = 3.0;
    
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        List<class_1268> hands = getAllHands();
        hands.remove(hand);
        class_1799 stack = user.method_5998(hand);
        class_1799 amelStack = null;
        class_1268 amelHand = null;
        for (class_1268 selectedHand : hands) {
            class_1799 possiblyAmel = user.method_5998(selectedHand);
            if (!Mutables.isAmel(possiblyAmel.method_7909())) continue;
            else if (possiblyAmel.method_7947() < 10) continue;
            amelStack = possiblyAmel;
            amelHand = selectedHand;
        }
        if (amelStack == null) return class_1271.method_22431(stack);
        user.method_6122(
            amelHand,
            amelStack.method_7947() == 10 ? class_1799.field_8037.method_7972() : new class_1799(
                amelStack.method_7909(),
                amelStack.method_7947() - 10
            )
        );
        this.setPlaceInAmbit(stack, user.method_33571());
        return class_1271.method_29237(stack, true);
    }

    public @Nullable class_243 getPlaceInAmbit(class_1799 stack) {
        Boolean isNull = NBTHelper.getBoolean(stack, PLACE_IN_AMBIT_IS_NULL);
        if (isNull == null || isNull) return null;
        double x = NBTHelper.getDouble(stack, PLACE_IN_AMBIT_X);
        double y = NBTHelper.getDouble(stack, PLACE_IN_AMBIT_Y);
        double z = NBTHelper.getDouble(stack, PLACE_IN_AMBIT_Z);
        return new class_243(x, y, z);
    }
    public void setPlaceInAmbit(class_1799 stack, @Nullable class_243 vec) {
        NBTHelper.putBoolean(stack, PLACE_IN_AMBIT_IS_NULL, vec == null);
        if (vec == null) return;
        NBTHelper.putDouble(stack, PLACE_IN_AMBIT_X, vec.field_1352);
        NBTHelper.putDouble(stack, PLACE_IN_AMBIT_Y, vec.field_1351);
        NBTHelper.putDouble(stack, PLACE_IN_AMBIT_Z, vec.field_1350);
    }

    @Override
    public void method_7851(
        class_1799 stack,
        @Nullable class_1937 world,
        List<class_2561> components,
        class_1836 flag
    ) {
        class_243 placeInAmbit = prettifyVec3d(this.getPlaceInAmbit(stack));
        components.add(
            class_2561.method_43471("tooltips.lapisworks.amel_orb.pre")
                .method_27692(class_124.field_1078)
                .method_10852(
                    placeInAmbit == null ?
                    class_2561.method_43471("tooltips.lapisworks.amel_orb.none")
                        .method_27692(class_124.field_1080) :
                    class_2561.method_43469(
                        "tooltips.lapisworks.amel_orb.set", placeInAmbit.field_1352, placeInAmbit.field_1351, placeInAmbit.field_1350
                    ).method_27692(class_124.field_1060)
            )
        );
    }
}
