package com.luxof.lapisworks.items;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.HexBaubleItem;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;

import java.util.List;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class FocusNecklace extends class_1792 implements HexBaubleItem, IotaHolderItem {
    public FocusNecklace(class_1793 settings) { super(settings); }
    
    public static final String TAG_DATA = "data";

    @Override
    public @Nullable class_2487 readIotaTag(class_1799 stack) {
        return NBTHelper.getCompound(stack, TAG_DATA);
    }

    @Override
    public boolean writeable(class_1799 stack) { return true; }

    @Override
    public boolean canWrite(class_1799 stack, @Nullable Iota iota) { return true; }

    @Override
    public void writeDatum(class_1799 stack, @Nullable Iota iota) {
        if (iota == null) {
            stack.method_7983(TAG_DATA);
        } else {
            NBTHelper.put(stack, TAG_DATA, IotaType.serialize(iota));
        }
    }

    @Override
    public Multimap<class_1320, class_1322> getHexBaubleAttrs(class_1799 stack) {
        return ImmutableMultimap.of();
    }

    @Override
    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents,
        class_1836 pIsAdvanced) {
        IotaHolderItem.appendHoverText(this, pStack, pTooltipComponents, pIsAdvanced);
    }
}
