package com.luxof.lapisworks.items;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.misc.MediaConstants;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.MediaHelper;

import com.luxof.lapisworks.Lapisworks;

import static com.luxof.lapisworks.LapisworksIDs.DOWSER_COULDNT_FIND;
import static com.luxof.lapisworks.LapisworksIDs.DOWSER_NOT_ENOUGH_MEDIA;
import static com.luxof.lapisworks.LapisworksIDs.DOWSE_TS;
import static com.luxof.lapisworks.LapisworksIDs.GEODE_DOWSER_REQUEST;

import com.mojang.datafixers.util.Pair;

import java.util.List;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class GeodeDowser extends class_1792 {
    public GeodeDowser(class_1793 settings) { super(settings); }

    public long getMediaCost() { return MediaConstants.DUST_UNIT * 1; }
    public Pair<class_2338, class_2338> getSearchAreaDimensions() {
        return new Pair<class_2338, class_2338>(
            new class_2338(-100, -100, -100),
            new class_2338(100, 100, 100)
        );
    }

    public void serverHandleDowseResult(class_3222 plr, class_2540 buf) {
        if (!buf.readBoolean()) {
            plr.method_43496(DOWSER_COULDNT_FIND);
            return;
        }

        class_2338 closestBuddingPos = buf.method_10811();
        double closestBuddingDistance = buf.readDouble();

        FrozenPigment color = getColorBasedOnDistanceSqr(closestBuddingDistance);
        class_243 end = closestBuddingPos.method_46558();
        class_243 eyePos = plr.method_33571();
        class_243 point = eyePos.method_1019(end.method_1020(eyePos).method_1029());
        ParticleSpray.burst(point, 5, 30).sprayParticles((class_3218)plr.method_37908(), color);
    }

    // i'd use POIs but budding amethyst that's already there won't be registered then (i think)
    // which is a problem for migrators
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) return class_1271.method_22427(user.method_5998(hand));

        class_3222 plr = (class_3222)user;

        List<ADMediaHolder> sources = MediaHelper.scanPlayerForMediaStuff(plr);
        long left = getMediaCost();
        for (ADMediaHolder source : sources) {
            long found = MediaHelper.extractMedia(source, left, true, false);
            left -= found;
            if (left == 0) break;
        }
        if (left > 0) {
            plr.method_43496(
                class_2561.method_43469(
                    DOWSER_NOT_ENOUGH_MEDIA,
                    getMediaCost() / MediaConstants.DUST_UNIT
                )
            );
            return class_1271.method_22431(plr.method_5998(hand));
        }

        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(GEODE_DOWSER_REQUEST);
        buf.method_10812(class_7923.field_41175.method_10221(class_2246.field_27160));
        ServerPlayNetworking.send(plr, DOWSE_TS, buf);
        return class_1271.method_22427(plr.method_5998(hand));
    }

    public FrozenPigment getColorBasedOnDistanceSqr(double distanceSqr) {
        // i hope constant-rolling exists in the Java compiler
        if (distanceSqr < 16*16) return Lapisworks.getPigmentFromDye(class_1767.field_7966);
        else if (distanceSqr < 32*32) return Lapisworks.getPigmentFromDye(class_1767.field_7951);
        else if (distanceSqr < 48*48) return Lapisworks.getPigmentFromDye(class_1767.field_7945);
        else if (distanceSqr < 64*64) return Lapisworks.getPigmentFromDye(class_1767.field_7954);
        else if (distanceSqr < 80*80) return Lapisworks.getPigmentFromDye(class_1767.field_7946);
        else if (distanceSqr < 96*96) return Lapisworks.getPigmentFromDye(class_1767.field_7964);
        else return Lapisworks.getPigmentFromDye(class_1767.field_7963);
    }
}
